/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.registries.item.types.curio.CurioAccessoryItem;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import pro.komaru.tridot.util.struct.data.Seq;

public abstract class AbstractCurioBuilder<T extends CurioAccessoryItem, B extends AbstractCurioBuilder<T, B>> {
    public Tier tier;
    public Item.Properties itemProperties;
    public ResourceLocation texPath;
    public boolean dependsOnStack = true;
    public Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> attributeMap = HashMultimap.create();
    public Multimap<String, AbstractArmorBuilder.AttributeData> slotModifiers = HashMultimap.create();
    public Seq<MobEffectInstance> effects = Seq.with();
    public SoundEvent equipSound;
    public float volume = 1.0f;
    public float pitch = 1.0f;

    public AbstractCurioBuilder(Tier tier, Item.Properties properties) {
        this.tier = tier;
        this.itemProperties = properties;
    }

    public B self() {
        return (B)this;
    }

    public B equipSound(SoundEvent soundEvent, float vol, float pitch) {
        this.equipSound = soundEvent;
        this.volume = vol;
        this.pitch = pitch;
        return this.self();
    }

    public B equipSound(SoundEvent soundEvent) {
        this.equipSound = soundEvent;
        return this.self();
    }

    public B addEffects(MobEffectInstance ... effects) {
        this.effects.addAll((Object[])effects);
        return this.self();
    }

    public B setEffects(Seq<MobEffectInstance> effects) {
        this.effects = effects;
        return this.self();
    }

    public B addEffect(MobEffectInstance effect) {
        this.effects.add((Object)effect);
        return this.self();
    }

    public B addSlots(Multimap<String, AbstractArmorBuilder.AttributeData> map) {
        this.slotModifiers.putAll(map);
        return this.self();
    }

    public B setSlots(Multimap<String, AbstractArmorBuilder.AttributeData> map) {
        this.slotModifiers = map;
        return this.self();
    }

    public B addSlot(String attribute, AbstractArmorBuilder.AttributeData mod) {
        this.slotModifiers.put((Object)attribute, (Object)mod);
        return this.self();
    }

    public B addAttrs(Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> map) {
        this.attributeMap.putAll(map);
        return this.self();
    }

    public B setAttrs(Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> map) {
        this.attributeMap = map;
        return this.self();
    }

    public B addAttr(Supplier<Attribute> attribute, AbstractArmorBuilder.AttributeData mod) {
        this.attributeMap.put(attribute, (Object)mod);
        return this.self();
    }

    public B setTexPath(ResourceLocation texPath) {
        this.texPath = texPath;
        return this.self();
    }

    public B setDependsOnStack(boolean dependsOnStack) {
        this.dependsOnStack = dependsOnStack;
        return this.self();
    }

    public abstract T build();
}

