/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.projectile.CrystalShard;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class CrystalShardItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> tridentAttributes;
    public final ImmutableList<MobEffectInstance> effects;
    public ArcRandom arc = Tmp.rnd;

    public CrystalShardItem(double damage, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(builderIn);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()), (Object)new AttributeModifier(Tridot.BASE_PROJECTILE_DAMAGE_UUID, "Tool modifier", damage * 2.0, AttributeModifier.Operation.ADDITION));
        this.tridentAttributes = builder.build();
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 6) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(entityLiving.m_7655_()));
                    CrystalShard shard = this.shootProjectile(worldIn, playerEntity);
                    worldIn.m_7967_((Entity)shard);
                    worldIn.m_6269_(playerEntity, (Entity)shard, (SoundEvent)SoundsRegistry.CRYSTAL_FROST_PREPARE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!playerEntity.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    private CrystalShard shootProjectile(Level worldIn, Player playerEntity) {
        CrystalShard shard = new CrystalShard(worldIn, (LivingEntity)playerEntity, playerEntity.m_21133_((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()));
        shard.setEffectsFromList(this.effects);
        shard.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.5f, 1.0f);
        if (playerEntity.m_150110_().f_35937_) {
            shard.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return shard;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Utils.Entities.applyWithChance((LivingEntity)target, this.effects, (float)1.0f, (ArcRandom)this.arc);
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.tridentAttributes : super.m_7167_(equipmentSlot);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        Utils.Items.effectTooltip(this.effects, tooltip, (float)1.0f, (float)1.0f);
    }
}

