/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.level.feature;

import com.idark.valoria.registries.level.configurations.CrystalBlobConfiguration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import pro.komaru.tridot.util.Tmp;

public class CrystalBlobFeature
extends Feature<CrystalBlobConfiguration> {
    public CrystalBlobFeature(Codec<CrystalBlobConfiguration> codec) {
        super(codec);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, DripstoneUtils::m_159666_);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalBlobConfiguration> context) {
        BlockPos origin = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        CrystalBlobConfiguration config = (CrystalBlobConfiguration)context.m_159778_();
        if (!CrystalBlobFeature.isEmptyOrWaterOrLava((LevelAccessor)world, origin)) {
            return false;
        }
        while (origin.m_123342_() > world.m_141937_() + 3 && world.m_46859_(origin.m_7495_())) {
            origin = origin.m_7495_();
        }
        if (origin.m_123342_() <= world.m_141937_() + 3) {
            return false;
        }
        int baseRadius = 1 + random.m_188503_(2);
        int height = 6 + random.m_188503_(4);
        ArrayList<BlockPos> blobPositions = new ArrayList<BlockPos>();
        for (int y = 0; y < height; ++y) {
            float radius = (float)baseRadius * (1.0f - (float)y / (float)height) + 0.5f;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-baseRadius, y, -baseRadius), (BlockPos)origin.m_7918_(baseRadius, y, baseRadius))) {
                Vec3i vec3i = new Vec3i(origin.m_123341_(), origin.m_123342_() + y, origin.m_123343_());
                if (pos.m_123331_(vec3i) <= (double)(radius * radius)) {
                    world.m_7731_(pos, config.state, 3);
                    blobPositions.add(pos.m_7949_());
                }
                if (!((double)random.m_188501_() < 0.5)) continue;
                BlockPos sideOffset = origin.m_7918_(random.m_188503_(3) - 1, y, random.m_188503_(3) - 1);
                world.m_7731_(sideOffset, config.state, 3);
                blobPositions.add(sideOffset.m_7949_());
            }
        }
        List<BlockState> crystals = config.outerDecoration;
        block3: for (BlockPos pos : blobPositions) {
            for (Direction dir : Direction.values()) {
                BlockPos targetPos = pos.m_121945_(dir);
                if (!world.m_8055_(targetPos).m_60795_()) continue;
                if (!Tmp.rnd.chance(config.chance)) continue block3;
                BlockState crystal = (BlockState)Util.m_214621_(crystals, (RandomSource)random);
                if (crystal.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    crystal = (BlockState)crystal.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
                }
                world.m_7731_(targetPos, crystal, 2);
                continue block3;
            }
        }
        return true;
    }
}

