/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ServerHaloPacket {

    public record Remove(UUID playerUUID) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
        }

        public static Remove decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            return new Remove(uuid);
        }

        public void execute(@Nullable Player playerEntity) {
            if (playerEntity != null && playerEntity.m_20194_() != null && this.playerUUID() != null) {
                ServerPerkData.HALO_INSTANCE.removePerk(playerEntity.m_20194_(), this.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, Halo halo) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
            Halo.write(buf, this.halo());
        }

        public static Apply decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            Halo halo = Halo.read(buf);
            return new Apply(uuid, halo);
        }

        public void execute(@Nullable Player playerEntity) {
            if (playerEntity != null && playerEntity.m_20194_() != null && this.playerUUID() != null && this.halo() != null) {
                ServerPerkData.HALO_INSTANCE.applyPerkWithVerification(playerEntity.m_20194_(), this.playerUUID(), this.halo());
            }
        }
    }
}

