/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.dispatch.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.animation.AzAnimatorAccessor;
import mod.azure.azurelib.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.animation.dispatch.command.AzControllerCommandBuilder;
import mod.azure.azurelib.animation.dispatch.command.AzRootCommandBuilder;
import mod.azure.azurelib.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.network.packet.AzBlockEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.util.codec.AzListStreamCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public record AzCommand(List<AzAction> actions) {
    public static final AzListStreamCodec<AzAction> ACTION_LIST_CODEC = new AzListStreamCodec<AzAction>(AzAction::decode, (buf, action) -> action.encode((FriendlyByteBuf)buf));
    public static final Function<FriendlyByteBuf, AzCommand> DECODER = buf -> {
        List<AzAction> actions = ACTION_LIST_CODEC.decode((FriendlyByteBuf)buf);
        return new AzCommand(actions);
    };
    public static final BiConsumer<FriendlyByteBuf, AzCommand> ENCODER = (buf, command) -> ACTION_LIST_CODEC.encode((FriendlyByteBuf)buf, command.actions());

    public static AzRootCommandBuilder rootBuilder() {
        return new AzRootCommandBuilder();
    }

    public static AzControllerCommandBuilder controllerBuilder() {
        return new AzControllerCommandBuilder();
    }

    public static AzCommand compose(Collection<AzCommand> commands) {
        if (commands.isEmpty()) {
            throw new IllegalArgumentException("Attempted to compose an empty collection of commands.");
        }
        if (commands.size() == 1) {
            return commands.iterator().next();
        }
        return new AzCommand(commands.stream().flatMap(command -> command.actions().stream()).toList());
    }

    public static AzCommand compose(AzCommand first, AzCommand second, AzCommand ... others) {
        ArrayList<AzCommand> allCommands = new ArrayList<AzCommand>();
        allCommands.add(first);
        allCommands.add(second);
        Collections.addAll(allCommands, others);
        return AzCommand.compose(allCommands);
    }

    public static AzCommand create(String controllerName, String animationName) {
        return AzCommand.create(controllerName, animationName, AzPlayBehaviors.PLAY_ONCE, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior) {
        return AzCommand.create(controllerName, animationName, playBehavior, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior, float startTickOffset, float animationSpeed, float transitionLength, float freezeTickOffset, float repeatXTimes, boolean isReversing) {
        return AzCommand.controllerBuilder().playSequence(controllerName, sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).setFreezeTickOffset(controllerName, freezeTickOffset).setStartTickOffset(controllerName, startTickOffset).setSpeed(controllerName, animationSpeed).setRepeatAmount(controllerName, repeatXTimes).setReverseAnimation(controllerName, isReversing).build();
    }

    public static AzCommand createRoot(String animationName, AzPlayBehavior playBehavior, float startTickOffset, float animationSpeed, float transitionLength, float freezeTickOffset, float repeatXTimes, boolean isReversing) {
        return AzCommand.rootBuilder().playSequence(sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).setFreezeTickOffset(freezeTickOffset).setTransitionSpeed(transitionLength).setStartTickOffset(startTickOffset).setSpeed(animationSpeed).setRepeatAmount(repeatXTimes).setReverseAnimation(isReversing).build();
    }

    public void sendForEntity(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            this.dispatchFromClient(entity);
        } else {
            int entityId = entity.m_19879_();
            AzEntityDispatchCommandPacket packet = new AzEntityDispatchCommandPacket(entityId, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    public void sendForBlockEntity(BlockEntity entity) {
        if (entity.m_58904_().m_5776_()) {
            this.dispatchFromClient(entity);
        } else {
            BlockPos entityBlockPos = entity.m_58899_();
            AzBlockEntityDispatchCommandPacket packet = new AzBlockEntityDispatchCommandPacket(entityBlockPos, this);
            Services.NETWORK.sendToEntitiesTrackingChunk(packet, (ServerLevel)entity.m_58904_(), entityBlockPos);
        }
    }

    public void sendForItem(Entity entity, ItemStack itemStack) {
        if (entity.m_9236_().m_5776_()) {
            this.dispatchFromClient(entity);
        } else {
            if (!itemStack.m_41783_().m_128441_("az_id")) {
                AzureLib.LOGGER.warn(AzureLib.MAIN_MARKER, "Missing '{}' UUID tag on ItemStack (item={}). Cannot dispatch animation commands. Ensure this is an AzureLib-animated item and that its UUID is assigned.", (Object)"az_id", (Object)itemStack.m_41720_().m_204114_().m_205785_().m_135782_());
                return;
            }
            UUID uuid = itemStack.m_41783_().m_128342_("az_id");
            AzItemStackDispatchCommandPacket packet = new AzItemStackDispatchCommandPacket(uuid, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    private <T> void dispatchFromClient(T animatable) {
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator != null) {
            this.actions.forEach(action -> action.handle(AzDispatchSide.CLIENT, animator));
        }
    }
}

