/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required;

import com.mojang.blaze3d.vertex.PoseStack;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.telemetry.IssueReportManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class WorldRendererMixin
implements WorldRendererDuck {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private Frustum f_172938_;
    @Shadow
    @Nullable
    private Frustum f_109442_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    private int f_109477_;
    @Shadow
    @Final
    private Vector3d f_109444_;
    @Shadow
    @Final
    private Minecraft f_109461_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(this.f_109461_);
    }

    @Override
    public Renderer betterclouds$getRenderer() {
        return this.cloudRenderer;
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/resource/ResourceManager;)V"})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        block5: {
            if (!BetterClouds.isInitialized()) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            try {
                if (this.cloudRenderer != null) {
                    this.cloudRenderer.reload(manager);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while reloading resources: " + e.getMessage())) break block5;
                throw e;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorld"})
    private void onSetWorld(ClientLevel world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Unique
    private Vector3d getCapturedFrustumPosition() {
        return new Vector3d((Vector3dc)this.f_109444_);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderClouds(PoseStack matrices, Matrix4f projMat, float tickDelta, double camX, double camY, double camZ, CallbackInfo ci) {
        block14: {
            Matrix4f viewMat = matrices.m_85850_().m_252922_();
            if (this.cloudRenderer == null) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            if (this.f_109465_ == null) {
                return;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(this.f_109465_.m_204156_().m_203543_().orElse(null))) {
                return;
            }
            if (!BetterClouds.isEnabled()) {
                return;
            }
            ProfilerWrapper.getProfiler().m_6180_("betterclouds");
            GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
            Vector3d cam = this.tempVector.set(camX, camY, camZ);
            Frustum frustum = this.f_172938_;
            Vector3d frustumPos = cam;
            if (this.f_109442_ != null) {
                frustumPos = this.getCapturedFrustumPosition();
                frustum = this.f_109442_;
                frustum.m_113002_(frustumPos.x, frustumPos.y, frustumPos.z);
            }
            int ticks = this.f_109477_;
            if (Debug.animationPause >= 0) {
                if (Debug.animationPause == 0) {
                    Debug.animationPause = ticks;
                } else {
                    ticks = Debug.animationPause;
                }
                tickDelta = 0.0f;
            }
            try {
                Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
                if (RenderDoc.isFrameCapturing()) {
                    GLCompat.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
                }
                if (prepareResult != Renderer.PrepareResult.FALLBACK) {
                    ci.cancel();
                }
                if (prepareResult == Renderer.PrepareResult.RENDER) {
                    this.cloudRenderer.render(ticks, tickDelta, cam, frustumPos, frustum);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while rendering: " + e.getMessage())) break block14;
                throw e;
            }
        }
        ProfilerWrapper.getProfiler().m_7238_();
        GLCompat.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

