/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer.replacer;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.werdei.biome_replacer.BiomeReplacer;
import net.werdei.biome_replacer.config.Config;
import net.werdei.biome_replacer.mixin.MultiNoiseBiomeSourceAccessor;

public class VanillaReplacer {
    private static Map<Holder<Biome>, Holder<Biome>> replacementRules;
    private static Map<String, Map<Holder<Biome>, Holder<Biome>>> dimensionReplacementRules;

    public static void doReplacement(Registry<Biome> biomeRegistry, Registry<LevelStem> stemRegistry) {
        VanillaReplacer.PrepareRules(biomeRegistry);
        if (replacementRules.isEmpty() && (dimensionReplacementRules == null || dimensionReplacementRules.isEmpty())) {
            BiomeReplacer.log("No rules found, not replacing anything");
            return;
        }
        HashSet<String> knownDimensions = new HashSet<String>();
        for (Iterator<String> entry : stemRegistry.m_6579_()) {
            knownDimensions.add(((ResourceKey)entry.getKey()).m_135782_().toString());
        }
        if (dimensionReplacementRules != null && !dimensionReplacementRules.isEmpty()) {
            HashMap<String, List> ruleLinesByDimension = new HashMap<String, List>();
            for (Config.Rule rule : Config.rules) {
                String dimension = rule.dimension();
                if (dimension == null) continue;
                ruleLinesByDimension.computeIfAbsent(dimension, __ -> new ArrayList()).add(rule.line());
            }
            for (String dimId : dimensionReplacementRules.keySet()) {
                List offendingLines;
                if (knownDimensions.contains(dimId) || (offendingLines = (List)ruleLinesByDimension.get(dimId)) == null) continue;
                Iterator iterator = offendingLines.iterator();
                while (iterator.hasNext()) {
                    int line = (Integer)iterator.next();
                    BiomeReplacer.logRuleWarning(line, String.format("Dimension '%s' does not exist, ignoring rule", dimId));
                }
            }
        }
        for (Map.Entry levelStem : stemRegistry.m_6579_()) {
            Map<Holder<Biome>, Holder<Biome>> dimOverlay;
            NoiseBasedChunkGenerator generator;
            ResourceLocation levelId = ((ResourceKey)levelStem.getKey()).m_135782_();
            LevelStem level = (LevelStem)levelStem.getValue();
            ChunkGenerator line = level.f_63976_();
            if (!(line instanceof NoiseBasedChunkGenerator) || !((generator = (NoiseBasedChunkGenerator)line).m_62218_() instanceof MultiNoiseBiomeSource)) {
                BiomeReplacer.log("Skipping " + String.valueOf(levelId));
                continue;
            }
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)generator.m_62218_();
            Climate.ParameterList parameters = (Climate.ParameterList)biomeSource.getParameters().map(p -> p, holder -> ((MultiNoiseBiomeSourceParameterList)holder.m_203334_()).m_274385_());
            ArrayList<Pair> newParameterList = new ArrayList<Pair>();
            HashMap<Holder<Biome>, Holder<Biome>> merged = new HashMap<Holder<Biome>, Holder<Biome>>();
            if (replacementRules != null && !replacementRules.isEmpty()) {
                merged.putAll(replacementRules);
            }
            Map<Holder<Biome>, Holder<Biome>> map = dimOverlay = dimensionReplacementRules != null ? dimensionReplacementRules.get(levelId.toString()) : null;
            if (dimOverlay != null && !dimOverlay.isEmpty()) {
                merged.putAll(dimOverlay);
            }
            HashMap<Holder<Biome>, Holder<Biome>> effectiveRules = merged;
            for (Pair value : parameters.m_186850_()) {
                Holder<Biome> newBiome = VanillaReplacer.replaceFromMap((Holder<Biome>)((Holder)value.getSecond()), effectiveRules);
                if (newBiome == null) continue;
                newParameterList.add(new Pair((Object)((Climate.ParameterPoint)value.getFirst()), newBiome));
            }
            biomeSource.setParameters((Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.left((Object)new Climate.ParameterList(newParameterList)));
            BiomeReplacer.log("Successfully replaced biomes in " + String.valueOf(levelId));
        }
    }

    private static void PrepareRules(Registry<Biome> biomeRegistry) {
        replacementRules = new HashMap<Holder<Biome>, Holder<Biome>>();
        dimensionReplacementRules = new HashMap<String, Map<Holder<Biome>, Holder<Biome>>>();
        int rulesDirect = 0;
        int rulesTag = 0;
        int rulesIgnored = 0;
        for (Config.Rule rule : Config.rules) {
            try {
                Holder<Biome> newBiome;
                Map targetMap;
                Map map = targetMap = rule.dimension() == null ? replacementRules : dimensionReplacementRules.computeIfAbsent(rule.dimension(), k -> new HashMap());
                if (rule.from().startsWith("#")) {
                    TagKey<Biome> tagKey = VanillaReplacer.getBiomeTagKey(rule.from().substring(1));
                    newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                    for (Holder oldBiome : biomeRegistry.m_206058_(tagKey)) {
                        targetMap.putIfAbsent(oldBiome, newBiome);
                    }
                    ++rulesTag;
                    continue;
                }
                Holder<Biome> oldBiome = VanillaReplacer.getBiomeHolder(rule.from(), biomeRegistry);
                newBiome = VanillaReplacer.getBiomeHolder(rule.to(), biomeRegistry);
                targetMap.put(oldBiome, newBiome);
                ++rulesDirect;
            }
            catch (Exception e) {
                BiomeReplacer.logRuleWarning(rule.line(), e.getMessage() + ", ignoring rule");
                ++rulesIgnored;
            }
        }
        BiomeReplacer.log(String.format("Loaded %d rules (%d direct, %d tag-based) and ignored %d", rulesDirect + rulesTag, rulesDirect, rulesTag, rulesIgnored));
    }

    private static Holder<Biome> getBiomeHolder(String id, Registry<Biome> registry) throws Exception {
        if (id.equals("null")) {
            return null;
        }
        ResourceKey<Biome> resourceKey = VanillaReplacer.getBiomeResourceKey(id);
        Optional holder = registry.m_203636_(resourceKey);
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        throw new Exception(String.format("Biome '%s' does not exist", id));
    }

    private static ResourceKey<Biome> getBiomeResourceKey(String id) throws Exception {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome ID '%s'", id));
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocation);
    }

    private static TagKey<Biome> getBiomeTagKey(String id) throws Exception {
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
        if (resourceLocation == null) {
            throw new Exception(String.format("Invalid biome tag '#%s'", id));
        }
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocation);
    }

    public static Holder<Biome> replaceIfNeeded(Holder<Biome> original) {
        return VanillaReplacer.replaceIfNeeded(original, null);
    }

    public static Holder<Biome> replaceIfNeeded(Holder<Biome> original, String dimensionId) {
        if (dimensionId == null || dimensionReplacementRules == null || dimensionReplacementRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, replacementRules);
        }
        Map<Holder<Biome>, Holder<Biome>> dimensionRules = dimensionReplacementRules.get(dimensionId);
        if (dimensionRules == null || dimensionRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, replacementRules);
        }
        if (replacementRules == null || replacementRules.isEmpty()) {
            return VanillaReplacer.replaceFromMap(original, dimensionRules);
        }
        HashMap<Holder<Biome>, Holder<Biome>> merged = new HashMap<Holder<Biome>, Holder<Biome>>(replacementRules);
        merged.putAll(dimensionRules);
        return VanillaReplacer.replaceFromMap(original, merged);
    }

    private static Holder<Biome> replaceFromMap(Holder<Biome> original, Map<Holder<Biome>, Holder<Biome>> rules) {
        if (rules == null || rules.isEmpty()) {
            return original;
        }
        return rules.getOrDefault(original, original);
    }
}

