/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle.data;

import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class StarFlareData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<StarFlareData> DESERIALIZER = new ParticleOptions.Deserializer<StarFlareData>(){

        public StarFlareData fromCommand(ParticleType<StarFlareData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = (float)reader.readDouble();
            reader.expect(' ');
            float g = (float)reader.readDouble();
            reader.expect(' ');
            float b = (float)reader.readDouble();
            return new StarFlareData(r, g, b);
        }

        public StarFlareData fromNetwork(ParticleType<StarFlareData> particleTypeIn, FriendlyByteBuf buffer) {
            return new StarFlareData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<StarFlareData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(starFlareData -> Float.valueOf(starFlareData.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(starFlareData -> Float.valueOf(starFlareData.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(starFlareData -> Float.valueOf(starFlareData.getBlue()))).apply((Applicative)instance, StarFlareData::new));
    private final float red;
    private final float green;
    private final float blue;

    public StarFlareData(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ParticleType<StarFlareData> m_6012_() {
        return SkiesParticles.STAR_FLARE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBlue() {
        return this.blue;
    }
}

