/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.arcs;

import com.legacy.blue_skies.items.arcs.ArcItem;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;

public class AquaticArcItem
extends ArcItem {
    private static final AttributeModifier[] SWIM_SPEED_BOOSTS = new AttributeModifier[]{new AttributeModifier(UUID.fromString("f8edab1e-d58d-45b3-9615-d9f72f21c763"), "aquatic_swim_speed_1", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL), new AttributeModifier(UUID.fromString("4291562c-d877-4c00-b354-92758e421ee0"), "aquatic_swim_speed_2", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL)};

    public AquaticArcItem(int slotId) {
        super(slotId, "aquatic", new Item.Properties().m_41487_(1));
    }

    @Override
    public void onEquip(ItemStack stack, Player player) {
        int level;
        AttributeInstance swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (!swimSpeed.m_22109_(SWIM_SPEED_BOOSTS[Math.min(1, level = this.getFunctionalLevel(stack, player))])) {
            swimSpeed.m_22118_(SWIM_SPEED_BOOSTS[Math.min(1, level)]);
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Player player) {
        AttributeInstance swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        for (int i = 0; i < SWIM_SPEED_BOOSTS.length; ++i) {
            if (!swimSpeed.m_22109_(SWIM_SPEED_BOOSTS[i])) continue;
            swimSpeed.m_22130_(SWIM_SPEED_BOOSTS[i]);
        }
    }

    @Override
    public void serverTick(ItemStack stack, ServerPlayer player) {
        int level = this.getFunctionalLevel(stack, (Player)player);
        if (level > 1 && player.m_20094_() > 0 && player.m_20094_() % 15 == 0) {
            int amount = player.m_20094_() - (level - 1) * 10;
            player.m_7311_(amount);
        }
    }

    @Override
    public void refresh(ItemStack stack, Player player) {
        this.onUnequip(stack, player);
        this.onEquip(stack, player);
    }
}

