/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public abstract class BaseLargeMushroomFeature
extends AbstractSkyTreeFeature {
    public BaseLargeMushroomFeature(Codec<TreeConfiguration> config) {
        super(config, true);
    }

    public abstract boolean place(WorldGenLevel var1, RandomSource var2, BlockPos var3, BiConsumer<BlockPos, BlockState> var4);

    @Override
    @Internal
    public final boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedMushrooms, @Deprecated BiConsumer<BlockPos, BlockState> dontUseThis) {
        HashSet shrooms = Sets.newHashSet();
        if (this.place(world, rand, pos, (blockPos, blockState) -> {
            changedMushrooms.accept((BlockPos)blockPos, (BlockState)blockState);
            shrooms.add(blockPos);
        })) {
            for (BlockPos blockPos2 : shrooms) {
                for (Direction dir : Direction.values()) {
                    TreeFeature.m_67256_((LevelWriter)world, (BlockPos)blockPos2, (BlockState)world.m_8055_(blockPos2).m_60728_(dir, world.m_8055_(blockPos2.m_121945_(dir)), (LevelAccessor)world, blockPos2, blockPos2.m_121945_(dir)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBlockIfOk(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof HugeMushroomBlock) {
            if (this.isReplaceableByMushroom(world, pos)) {
                this.setBlock(changedBlocks, world, pos, state);
                return true;
            }
            return false;
        }
        return super.setBlockIfOk(changedBlocks, world, pos, state);
    }

    @Override
    public boolean isReplaceableByLeaves(WorldGenLevel world, BlockPos pos) {
        return this.isReplaceableByMushroom(world, pos);
    }

    @Override
    public boolean isReplaceableByLogs(WorldGenLevel world, BlockPos pos) {
        return this.isReplaceableByMushroom(world, pos);
    }

    public boolean isReplaceableByMushroom(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return this.isMushroomBlock(state) || this.isMushroomStem(state) || super.isReplaceableByLogs(world, pos) || super.isReplaceableByLeaves(world, pos);
    }

    @Override
    public boolean isValidGround(WorldGenLevel world, BlockState state, BlockPos pos) {
        return super.isValidGround(world, state, pos) || state.m_204336_(BlockTags.f_13057_);
    }

    public boolean isMushroomStem(BlockState state) {
        return state.m_60734_() instanceof HugeMushroomBlock;
    }

    public boolean isMushroomBlock(BlockState state) {
        return state.m_60734_() instanceof HugeMushroomBlock;
    }
}

