/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.core.MarkSymbol;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;

public class SymbolUnlocking {
    public static List<MarkSymbol> getUnlockedSymbols(ServerPlayer player) {
        ArrayList<MarkSymbol> unlocked = new ArrayList<MarkSymbol>();
        for (MarkSymbol symbol : MarkSymbol.getSpecialSymbols()) {
            String advancementLocation;
            Pair<ForgeConfigSpec.BooleanValue, ForgeConfigSpec.ConfigValue<String>> symbolConfig = Config.SYMBOL_CONFIG.get((Object)symbol);
            if (!((Boolean)((ForgeConfigSpec.BooleanValue)symbolConfig.getFirst()).get()).booleanValue() || !(advancementLocation = (String)((ForgeConfigSpec.ConfigValue)symbolConfig.getSecond()).get()).isEmpty() && !SymbolUnlocking.hasAdvancement(player, new ResourceLocation(advancementLocation))) continue;
            unlocked.add(symbol);
        }
        return unlocked;
    }

    private static boolean hasAdvancement(ServerPlayer player, ResourceLocation advancementID) {
        MinecraftServer server = player.m_9236_().m_7654_();
        if (server == null) {
            Chalk.LOGGER.error("Cannot check advancements: server is null");
            return false;
        }
        Advancement advancement = server.m_129889_().m_136041_(advancementID);
        if (advancement == null) {
            return false;
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
        return progress.m_8193_();
    }
}

