/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.items;

import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ChalkItem
extends Item
implements IDrawingTool {
    private final DyeColor color;

    public ChalkItem(DyeColor dyeColor, Item.Properties properties) {
        super(properties.m_41487_(1).m_41499_(64).setNoRepair());
        this.color = dyeColor;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (player == null || !(itemStack.m_41720_() instanceof ChalkItem)) {
            return InteractionResult.FAIL;
        }
        if (hand == InteractionHand.OFF_HAND && player.m_21205_().m_41720_() instanceof ChalkItem) {
            return InteractionResult.FAIL;
        }
        MarkDrawingContext drawingContext = this.createDrawingContext(player, context.m_8083_(), context.m_43720_(), context.m_43719_(), hand);
        if (!drawingContext.canDraw()) {
            return InteractionResult.FAIL;
        }
        if (player.m_36341_()) {
            drawingContext.openSymbolSelectionScreen();
            return InteractionResult.CONSUME;
        }
        if (this.drawMark(drawingContext, drawingContext.createRegularMark(ChalkColors.fromDyeColor(this.color), false))) {
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        if (drawingContext.hasExistingMark()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onMarkDrawn(Player player, InteractionHand hand, BlockPos markBlockPos, BlockState markBlockState) {
        if (player.m_7500_()) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        stack.m_41622_(1, (LivingEntity)player, pl -> pl.m_21190_(hand));
    }

    @Override
    public Mark getMark(ItemStack itemInHand, MarkDrawingContext drawingContext, MarkSymbol symbol) {
        return drawingContext.createMark(ChalkColors.fromDyeColor(this.getColor()), symbol, this.getGlowing(itemInHand));
    }

    @Override
    public int getMarkColorValue(ItemStack stack) {
        return ChalkColors.fromDyeColor(this.getColor());
    }

    @Override
    public Optional<DyeColor> getMarkColor(ItemStack stack) {
        return Optional.of(this.getColor());
    }

    @Override
    public boolean getGlowing(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)Config.CHALK_DURABILITY.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

