/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class SoulFurnaceScreen
extends AbstractContainerScreen<SoulFurnaceContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/gui/soul_furnace_gui.png");
    private static final int FRAME_WIDTH = 10;
    private static final int FRAME_HEIGHT = 9;
    private static final int FRAME_COUNT = 6;
    private static final int FRAME_BASE_X = 176;
    private static final int FRAME_BASE_Y = 31;
    private static final int FRAME_Y_OFFSET = 9;
    private final int[] animationTicks;
    private final int animationSpeeds = 3;
    private final int[] animationOffsets;

    public SoulFurnaceScreen(SoulFurnaceContainerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 179;
        int maxCharges = SoulFurnaceBlockEntity.getMaxCharges();
        this.animationTicks = new int[maxCharges];
        this.animationOffsets = new int[maxCharges];
        for (int i = 0; i < maxCharges; ++i) {
            this.animationOffsets[i] = new Random().nextInt(6);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        int i = 0;
        while (i < this.animationTicks.length) {
            int n = i++;
            this.animationTicks[n] = this.animationTicks[n] + 1;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        if (((SoulFurnaceContainerMenu)this.f_97732_).getProcessingTime() > 0) {
            int progressWidth = 24;
            int progressHeight = 17;
            int progress = (int)((float)((SoulFurnaceContainerMenu)this.f_97732_).getProgress() / (float)((SoulFurnaceContainerMenu)this.f_97732_).getProcessingTime() * (float)progressWidth);
            guiGraphics.m_280218_(TEXTURE, relX + 79, relY + 40, 176, 14, progress, progressHeight);
        }
        int chargeCount = ((SoulFurnaceContainerMenu)this.f_97732_).getCharge();
        for (int i = 0; i < chargeCount; ++i) {
            int drawY;
            int drawX;
            int currentFrame = (this.animationTicks[i] / 3 + this.animationOffsets[i]) % 6;
            int frameY = 31 + currentFrame * 9;
            if (i == 0) {
                drawX = relX + 9;
                drawY = relY + 61;
            } else if (i == SoulFurnaceBlockEntity.getMaxCharges() - 1) {
                drawX = relX + 157;
                drawY = relY + 61;
            } else {
                drawX = relX + 26 + (i - 1) * 19;
                drawY = relY + 69;
            }
            guiGraphics.m_280218_(TEXTURE, drawX, drawY, 176, frameY, 10, 9);
        }
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ + 2, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 14, 0x404040, false);
    }
}

