/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.block.SoulFurnaceBlock;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsRecipes;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class SoulFurnaceBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
Container {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private static final int MAX_CHARGES = 9;
    public int charges = 0;
    private int currentProgress = 0;
    private int processingTime = 0;
    @Nullable
    private SoulFurnaceRecipe currentRecipe = null;
    public boolean isLit = false;

    public SoulFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.SOUL_FURNACE.get(), pos, state);
    }

    public boolean m_7013_(int pIndex, @NotNull ItemStack pStack) {
        return pIndex == 0;
    }

    public boolean m_271862_(@NotNull Container pTarget, int pIndex, @NotNull ItemStack pStack) {
        return pIndex == 1;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        ItemStack inputStack;
        SoulFurnaceRecipe found;
        SoulFurnaceBlockEntity furnace;
        block8: {
            block7: {
                if (!(be instanceof SoulFurnaceBlockEntity)) break block7;
                furnace = (SoulFurnaceBlockEntity)be;
                if (!level.m_5776_()) break block8;
            }
            return;
        }
        furnace.handleGreatChaliceInteraction(level, pos);
        if (furnace.currentRecipe == null && !furnace.m_8020_(0).m_41619_() && (found = furnace.findRecipe(level, inputStack = furnace.m_8020_(0))) != null) {
            inputStack.m_41774_(1);
            furnace.currentRecipe = found;
            furnace.processingTime = found.processTime();
            furnace.currentProgress = 0;
            furnace.m_6596_();
        }
        if (furnace.currentRecipe != null) {
            furnace.handleCooking(pos, level, state);
        }
        boolean lit = furnace.currentRecipe != null;
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_61138_((Property)SoulFurnaceBlock.LIT) && (Boolean)currentState.m_61143_((Property)SoulFurnaceBlock.LIT) != lit) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)SoulFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
        if (CompanionsConfig.SOUL_FURNACE_CONSTANT_MAX_CHARGES) {
            furnace.charges = 9;
        }
    }

    private void handleGreatChaliceInteraction(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
        if (blockEntity instanceof GreatChaliceBlockEntity) {
            GreatChaliceBlockEntity be = (GreatChaliceBlockEntity)blockEntity;
            if (this.charges < 9 && be.isFull()) {
                be.setCharges(0);
                level.m_5594_(null, pos.m_7494_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.charges = Math.min(this.charges + 1, 9);
                this.m_6596_();
            }
        }
    }

    private void handleCooking(BlockPos pos, Level level, BlockState state) {
        SoulFurnaceRecipe next;
        ++this.currentProgress;
        if (this.currentRecipe == null) {
            return;
        }
        if (this.currentProgress < this.processingTime) {
            return;
        }
        SoulFurnaceRecipe recipe = this.currentRecipe;
        level.m_5594_(null, pos.m_7494_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (recipe.outputsItem()) {
            ItemStack output = new ItemStack((ItemLike)recipe.resultItem(), Math.max(1, recipe.resultCount()));
            ItemStack current = this.m_8020_(1);
            if (current.m_41619_()) {
                this.m_6836_(1, output);
            } else if (ItemStack.m_150942_((ItemStack)current, (ItemStack)output) || current.m_150930_(output.m_41720_())) {
                current.m_41769_(output.m_41613_());
            } else {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)output);
            }
        } else if (recipe.outputsEntity()) {
            BlockPos spawnPos = pos.m_121945_((Direction)state.m_61143_((Property)SoulFurnaceBlock.FACING));
            Entity e = recipe.resultEntity().m_20615_(level);
            if (e != null) {
                e.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                level.m_7967_(e);
            }
        } else if (recipe.outputsBlock()) {
            Block target = recipe.resultBlock();
            BlockPos targetPos = pos.m_121945_((Direction)state.m_61143_((Property)SoulFurnaceBlock.FACING));
            if (level.m_46859_(targetPos)) {
                BlockState recipeState = target.m_49966_();
                if (recipeState.m_61138_((Property)SoulFurnaceBlock.FACING)) {
                    recipeState = (BlockState)recipeState.m_61124_((Property)SoulFurnaceBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)SoulFurnaceBlock.FACING)));
                } else if (recipeState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    recipeState = (BlockState)recipeState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)SoulFurnaceBlock.FACING)));
                }
                level.m_46597_(targetPos, recipeState);
                this.spawnPoofParticles(targetPos);
            } else if (level.m_8055_(targetPos).m_60734_() == target) {
                BlockPos stackPos = targetPos;
                while (!level.m_46859_(stackPos) && stackPos.m_123342_() < level.m_151558_()) {
                    stackPos = stackPos.m_7494_();
                }
                if (level.m_46859_(stackPos)) {
                    level.m_46597_(stackPos, target.m_49966_());
                } else {
                    Containers.m_18992_((Level)level, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), (ItemStack)new ItemStack((ItemLike)target));
                }
            } else {
                Containers.m_18992_((Level)level, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), (ItemStack)new ItemStack((ItemLike)target));
            }
        }
        this.charges -= recipe.requiredCharges();
        this.currentRecipe = null;
        this.currentProgress = 0;
        this.processingTime = 0;
        this.m_6596_();
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_() && (next = this.findRecipe(level, stack)) != null) {
            stack.m_41774_(1);
            this.currentRecipe = next;
            this.processingTime = next.processTime();
            this.currentProgress = 0;
            this.m_6596_();
        }
    }

    @Nullable
    private SoulFurnaceRecipe findRecipe(Level level, ItemStack input) {
        if (input.m_41619_()) {
            return null;
        }
        List list = level.m_7465_().m_44013_((RecipeType)CompanionsRecipes.SOUL_FURNACE_TYPE.get());
        for (Recipe rec : list) {
            SoulFurnaceRecipe r;
            if (!(rec instanceof SoulFurnaceRecipe) || !(r = (SoulFurnaceRecipe)rec).input().test(input) || this.charges < r.requiredCharges()) continue;
            return r;
        }
        return null;
    }

    private void spawnPoofParticles(BlockPos targetPos) {
        for (int i = 0; i < 25; ++i) {
            double dx = (new Random().nextDouble() - 0.5) * 2.5;
            double dy = (new Random().nextDouble() - 0.5) * 1.5;
            double dz = (new Random().nextDouble() - 0.5) * 2.5;
            Level level = this.f_58857_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), 1, dx, dy, dz, 0.04);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.charges = tag.m_128451_("Charges");
        this.currentProgress = tag.m_128451_("Progress");
        this.processingTime = tag.m_128451_("ProcessingTime");
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Charges", this.charges);
        tag.m_128405_("Progress", this.currentProgress);
        tag.m_128405_("ProcessingTime", this.processingTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Soul Furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulFurnaceContainerMenu(id, inventory, this, new ContainerData(){

            public int m_6413_(int index) {
                if (index == 0) {
                    return SoulFurnaceBlockEntity.this.charges;
                }
                if (index == 1) {
                    return SoulFurnaceBlockEntity.this.currentProgress;
                }
                if (index == 2) {
                    return SoulFurnaceBlockEntity.this.processingTime;
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    SoulFurnaceBlockEntity.this.charges = value;
                } else if (index == 1) {
                    SoulFurnaceBlockEntity.this.currentProgress = value;
                } else if (index == 2) {
                    SoulFurnaceBlockEntity.this.processingTime = value;
                }
            }

            public int m_6499_() {
                return 3;
            }
        });
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        SoulFurnaceRecipe found;
        if (index == 0 && !stack.m_41619_() && this.currentRecipe == null && this.f_58857_ != null && !this.f_58857_.m_5776_() && (found = this.findRecipe(this.f_58857_, stack)) != null) {
            stack.m_41774_(1);
            this.currentRecipe = found;
            this.processingTime = found.processTime();
            this.currentProgress = 0;
            this.m_6596_();
        }
        this.items.set(index, (Object)stack);
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public static int getMaxCharges() {
        return 9;
    }

    public boolean isLit() {
        return this.isLit;
    }
}

