/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.wild.goal;

import dev.xylonity.companions.common.entity.hostile.WildAntlionEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class WildAntlionNearestAttackableTarget<T extends LivingEntity>
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final Class<T> targetType;
    protected final int randomInterval;
    protected LivingEntity target;
    protected TargetingConditions targetConditions;
    private final WildAntlionEntity antlion;

    public WildAntlionNearestAttackableTarget(WildAntlionEntity pMob, Class<T> pTargetType, boolean pMustSee) {
        this(pMob, pTargetType, 10, pMustSee, false, null);
    }

    public WildAntlionNearestAttackableTarget(WildAntlionEntity pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
        super((Mob)pMob, pMustSee, pMustReach);
        this.targetType = pTargetType;
        this.randomInterval = WildAntlionNearestAttackableTarget.m_186073_((int)pRandomInterval);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.antlion = pMob;
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(pTargetPredicate);
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.isValidTarget(this.target);
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        super.m_8056_();
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.f_26135_.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        this.target = this.f_26135_.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.m_7623_()), e -> true).stream().filter(this::isValidTarget).min(Comparator.comparingDouble(e -> e.m_20275_(this.f_26135_.m_20185_(), this.f_26135_.m_20186_(), this.f_26135_.m_20189_()))).orElse(null);
    }

    public void m_8037_() {
        if (this.target != null) {
            this.antlion.m_21391_((Entity)this.target, 30.0f, 30.0f);
        }
    }

    private boolean isValidTarget(LivingEntity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player p = (Player)e;
        if (p.m_7500_() || p.m_5833_()) {
            return false;
        }
        if (!this.antlion.m_142582_((Entity)p)) {
            return false;
        }
        return !(this.antlion.m_20154_().m_82541_().m_82526_(p.m_20182_().m_82546_(this.antlion.m_20182_()).m_82541_()) < 0.0) || !p.m_6144_();
    }
}

