/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EnderFrogFollowOwnerGoal
extends Goal {
    private final double minDistance;
    private final double startDistance;
    private final double maxSpeedModifier;
    private final float lerpFactor;
    private final EnderFrogEntity frog;
    private final PathNavigation navigation;
    private LivingEntity owner;

    public EnderFrogFollowOwnerGoal(EnderFrogEntity frog, double maxSpeedModifier, double minDistance, double startDistance, float lerpFactor) {
        this.frog = frog;
        this.maxSpeedModifier = maxSpeedModifier;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.navigation = this.frog.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity poss = this.frog.m_269323_();
        if (poss == null || !poss.m_6084_()) {
            return false;
        }
        if (this.frog.m_20280_((Entity)poss) < this.startDistance * this.startDistance) {
            return false;
        }
        this.owner = poss;
        return true;
    }

    public boolean m_8045_() {
        if (this.owner == null) {
            return false;
        }
        if (!this.owner.m_6084_()) {
            return false;
        }
        return this.frog.m_20280_((Entity)this.owner) > this.minDistance * this.minDistance;
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        this.frog.m_21391_((Entity)this.owner, 30.0f, 30.0f);
        double dx = this.owner.m_20185_() - this.frog.m_20185_();
        double dy = this.owner.m_20186_() + 2.0 - this.frog.m_20186_();
        double dz = this.owner.m_20189_() - this.frog.m_20189_();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist <= this.minDistance) {
            Vec3 slowed = this.frog.m_20184_().m_82490_(0.9);
            this.frog.m_20256_(slowed);
            if (slowed.m_82556_() < 0.01) {
                this.navigation.m_26573_();
                this.frog.m_21566_().m_6849_(this.frog.m_20185_(), this.frog.m_20186_(), this.frog.m_20189_(), 0.0);
            }
            return;
        }
        double theta = dist >= this.startDistance ? 1.0 : Mth.m_14008_((double)((dist - this.minDistance) / (this.startDistance - this.minDistance)), (double)0.0, (double)1.0);
        Vec3 target = new Vec3(this.owner.m_20185_() - dx / dist * this.minDistance, this.owner.m_20186_() + 2.0 - dy / dist * this.minDistance, this.owner.m_20189_() - dz / dist * this.minDistance);
        Vec3 vel = target.m_82546_(this.frog.m_20182_()).m_82541_().m_82490_(this.maxSpeedModifier * theta);
        Vec3 cVel = this.frog.m_20184_();
        this.frog.m_20256_(new Vec3(Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82479_, (double)vel.f_82479_), Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82480_, (double)vel.f_82480_), Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82481_, (double)vel.f_82481_)));
    }

    private boolean isPathBlocked(Level level, Vec3 from, Vec3 to) {
        return level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.frog)).m_6662_() != HitResult.Type.MISS;
    }
}

