/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SoulMageStoneSpikesGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageStoneSpikesGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "STONE_SPIKES");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null) {
            Vec3 baseDir = target.m_20182_().m_82546_(this.soulMage.m_20182_()).m_82541_();
            int spikes = 12;
            this.spawnSpikeRow(baseDir, spikes);
            this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -25.0), (int)((double)spikes * 0.7));
            this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 25.0), (int)((double)spikes * 0.7));
        }
    }

    private void spawnSpikeRow(Vec3 direction, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 pos = this.soulMage.m_20182_().m_82549_(direction.m_82490_(1.5 + (double)i * 1.5));
            int y = this.soulMage.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)pos.f_82479_, 0, (int)pos.f_82481_)).m_123342_();
            StoneSpikeProjectile spike = (StoneSpikeProjectile)((EntityType)CompanionsEntities.STONE_SPIKE_PROJECTILE.get()).m_20615_(this.soulMage.m_9236_());
            if (spike == null) continue;
            spike.m_7678_(pos.f_82479_, Util.findValidSpawnPos(new BlockPos((int)pos.f_82479_, y, (int)pos.f_82481_), this.soulMage.m_9236_()).m_123342_(), pos.f_82481_, this.soulMage.m_146908_(), 0.0f);
            spike.m_5602_((Entity)this.soulMage);
            if (i == 0) {
                this.soulMage.m_9236_().m_7967_((Entity)spike);
                continue;
            }
            TickScheduler.scheduleBoth((Level)this.soulMage.m_9236_(), () -> this.soulMage.m_9236_().m_7967_((Entity)spike), (int)(i * 2));
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.m_6643_(); ++i) {
            ItemStack stack = this.soulMage.inventory.m_8020_(i);
            if (stack.m_41720_() != CompanionsItems.BOOK_STONE_SPIKES.get()) continue;
            return true;
        }
        return false;
    }
}

