/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet;

import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractPuppetLeftAttackGoal
extends Goal {
    protected final PuppetEntity puppet;
    protected int attackTicks;
    protected int nextUseTick;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected boolean started;
    protected final String attackType;

    public AbstractPuppetLeftAttackGoal(PuppetEntity puppet, int minCd, int maxCd, String attackType) {
        this.puppet = puppet;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.attackType = attackType;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.puppet.isAttackingLeft()) {
            return false;
        }
        if (this.puppet.m_5448_() == null) {
            return false;
        }
        if (this.puppet.f_19797_ < this.nextUseTick) {
            return false;
        }
        return this.hasRequiredArm();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        return this.attackTicks < 13;
    }

    public void m_8056_() {
        this.attackTicks = 0;
        this.puppet.setAttackingLeft(true);
        this.started = true;
    }

    public void m_8041_() {
        this.started = false;
        this.puppet.setAttackingLeft(false);
        int randomCd = this.minCooldown + this.puppet.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.puppet.f_19797_ + randomCd;
    }

    public void m_8037_() {
        if (!this.started) {
            return;
        }
        LivingEntity target = this.puppet.m_5448_();
        if (target != null) {
            this.puppet.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
        }
        ++this.attackTicks;
        if (target != null) {
            this.puppet.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.shouldPerformAttack(target)) {
            this.performAttack(target);
        }
        if (this.attackTicks >= 13) {
            this.m_8041_();
        }
    }

    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 3 && target != null && target.m_6084_();
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract boolean hasRequiredArm();
}

