/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade.sword.goal;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.shade.AbstractShadeAttackGoal;
import dev.xylonity.companions.common.entity.companion.ShadeSwordEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ShadeSwordSpinAttackGoal
extends AbstractShadeAttackGoal {
    private double anchorY;

    public ShadeSwordSpinAttackGoal(ShadeEntity boss, int minCd, int maxCd) {
        super(boss, 30, minCd, maxCd);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.shade.setNoMovement(true);
        this.anchorY = this.shade.m_20186_();
        this.shade.m_216990_(CompanionsSounds.SHADE_SWORD_SPIN_SLASH.get());
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.shade.setNoMovement(false);
        this.shade.m_20256_(Vec3.f_82478_);
        this.shade.setShouldLookAtTarget(true);
    }

    @Override
    public void m_8037_() {
        LivingEntity target;
        if (this.attackTicks < 4) {
            this.shade.setShouldLookAtTarget(false);
        }
        if ((target = this.shade.m_5448_()) != null) {
            this.shade.m_6034_(this.shade.m_20185_(), this.anchorY, this.shade.m_20189_());
            this.shade.m_20256_(Vec3.f_82478_);
            float yaw = (float)(180.0 + Math.toDegrees(Math.atan2(target.m_20185_() - this.shade.m_20185_(), target.m_20189_() - this.shade.m_20189_())));
            this.shade.m_146922_(yaw);
            this.shade.m_5618_(yaw);
        }
        if (target != null) {
            this.shade.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks >= 5 && this.attackTicks <= 26 && this.attackTicks % 5 == 0 && target != null && target.m_6084_()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.shade.m_5448_() != null && this.shade.m_20270_((Entity)this.shade.m_5448_()) < 3.0f;
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (Entity e : this.shade.m_9236_().m_45976_(Entity.class, this.shade.m_20191_().m_82400_(3.25))) {
            LivingEntity livingEntity;
            if (!(e instanceof LivingEntity) || !this.shade.m_142582_((Entity)(livingEntity = (LivingEntity)e)) || Util.areEntitiesLinked(e, (Entity)this.shade)) continue;
            this.shade.m_7327_((Entity)livingEntity);
            livingEntity.m_147240_(0.5, this.shade.m_20185_() - target.m_20185_(), this.shade.m_20189_() - target.m_20189_());
        }
    }

    @Override
    protected int attackDelay() {
        return 0;
    }

    @Override
    protected Class<? extends ShadeEntity> shadeType() {
        return ShadeSwordEntity.class;
    }
}

