/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.ai.teddy.AbstractTeddyAttackGoal;
import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import dev.xylonity.companions.common.entity.projectile.NeedleProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeddyVoodooAttackGoal
extends AbstractTeddyAttackGoal {
    private List<LivingEntity> list = new ArrayList<LivingEntity>();

    public TeddyVoodooAttackGoal(TeddyEntity teddy, int minCd, int maxCd) {
        super(teddy, 21, minCd, maxCd);
    }

    @Override
    public boolean m_8036_() {
        this.list = this.teddy.m_9236_().m_6443_(LivingEntity.class, new AABB(this.teddy.m_20183_()).m_82400_(20.0), e -> e.m_21023_(CompanionsEffects.VOODOO.get()) && !Util.areEntitiesLinked((Entity)e, (Entity)this.teddy));
        if (this.list.isEmpty()) {
            return false;
        }
        if (this.teddy.getPhase() == 2) {
            return false;
        }
        if (this.phase() != this.teddy.getPhase()) {
            return false;
        }
        if (this.teddy.getAttackType() != 0) {
            return false;
        }
        if (this.teddy.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.teddy.f_19797_ + this.minCooldown + this.teddy.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.teddy.f_19797_ >= this.nextUseTick;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.teddy.setNoMovement(true);
        this.teddy.m_216990_(CompanionsSounds.TEDDY_AUTO_STAB.get());
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.list.clear();
        this.teddy.setNoMovement(false);
    }

    @Override
    public void m_8037_() {
        LivingEntity target = this.teddy.m_5448_();
        if (target != null) {
            this.teddy.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == 16) {
            this.performAttack(target);
        }
        if (this.attackTicks == this.attackDelay()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    @Override
    protected void performAttack(LivingEntity unused) {
        for (LivingEntity e : this.list) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.teddy)) continue;
            e.m_21195_(CompanionsEffects.VOODOO.get());
            for (int i = 0; i < 2; ++i) {
                double radius = 4.0 + this.teddy.m_217043_().m_188500_();
                double angle = this.teddy.m_217043_().m_188500_() * Math.PI * 2.0;
                double x = e.m_20185_() + Math.cos(angle) * radius;
                double y = e.m_20191_().f_82289_ + (double)e.m_20206_() * 0.75 + this.teddy.m_217043_().m_188500_() * (double)e.m_20206_() * 0.5 + 1.0;
                double z = e.m_20189_() + Math.sin(angle) * radius;
                NeedleProjectile needle = (NeedleProjectile)((EntityType)CompanionsEntities.NEEDLE_PROJECTILE.get()).m_20615_(this.teddy.m_9236_());
                if (needle == null) continue;
                needle.m_5602_((Entity)this.teddy);
                needle.m_20219_(new Vec3(x, y, z));
                needle.m_20256_(e.m_20182_().m_82549_(new Vec3(0.0, (double)e.m_20206_() * 0.65, 0.0)).m_82546_(new Vec3(x, y, z)).m_82541_().m_82490_(1.25));
                needle.refreshOrientation();
                needle.m_6842_(true);
                this.teddy.m_9236_().m_7967_((Entity)needle);
            }
        }
    }

    @Override
    protected int attackDelay() {
        return 7;
    }

    @Override
    protected int phase() {
        return 1;
    }

    @Override
    protected int getAttackType() {
        return 2;
    }
}

