/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.BlueStarExplosion;
import dev.xylonity.companions.common.entity.projectile.BlueStarExplosionCenter;
import dev.xylonity.companions.common.entity.projectile.RedStarExplosion;
import dev.xylonity.companions.common.entity.projectile.RedStarExplosionCenter;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.mixin.CompanionsProjectileAccessor;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HolinessStartProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> RED = SynchedEntityData.m_135353_(HolinessStartProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static float SPEED = 0.6f;
    private LivingEntity target;

    public HolinessStartProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected boolean m_5603_(@NotNull Entity pTarget) {
        if (Util.areEntitiesLinked((Entity)this, pTarget)) {
            return false;
        }
        if (!pTarget.m_271807_()) {
            return false;
        }
        Entity entity = this.m_19749_();
        return entity == null || ((CompanionsProjectileAccessor)((Object)this)).getLeftOwner() || !entity.m_20365_(pTarget);
    }

    @Override
    public void m_8119_() {
        Vec3 v;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.target != null && this.target.m_6084_()) {
            v = this.target.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)SPEED);
            this.m_20256_(this.m_20184_().m_165921_(v, 0.095).m_82541_().m_82490_((double)SPEED));
            this.f_19812_ = true;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            v = this.m_20184_();
            this.m_146922_((float)(Mth.m_14136_((double)v.f_82479_, (double)v.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)v.f_82480_, (double)v.m_165924_()) * 57.2957763671875));
        }
        if (this.f_19797_ % 8 == 0) {
            this.m_9236_().m_7106_(this.isRed() ? (ParticleOptions)CompanionsParticles.HOLINESS_RED_STAR_TRAIL.get() : (ParticleOptions)CompanionsParticles.HOLINESS_BLUE_STAR_TRAIL.get(), this.m_20185_(), this.m_20186_() - (double)this.m_20206_() * 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.m_20096_()) {
            Vec3 pos = this.m_20182_();
            Vec3 vec33 = pos.m_82549_(this.m_20184_());
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(pos, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.findHitEntity(pos, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            this.m_20101_();
        }
        if (this.m_20096_()) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 20 == 0 || this.f_19797_ == 1)) {
            Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.isRed() ? 0.8f : 0.09803922f, this.isRed() ? 0.19607843f : 0.54509807f, this.isRed() ? 0.19607843f : 0.3372549f, 0.0f, 0.35f);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_) {
            if (this.isRed()) {
                this.redExplosion();
            } else {
                this.blueExplosion();
            }
        } else {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
            }
        }
        super.m_142687_(pReason);
    }

    private void redExplosion() {
        RedStarExplosionCenter explosion2;
        RedStarExplosion explosion = (RedStarExplosion)((EntityType)CompanionsEntities.RED_STAR_EXPLOSION.get()).m_20615_(this.m_9236_());
        if (explosion != null) {
            explosion.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)explosion);
        }
        if ((explosion2 = (RedStarExplosionCenter)((EntityType)CompanionsEntities.RED_STAR_EXPLOSION_CENTER.get()).m_20615_(this.m_9236_())) != null) {
            explosion2.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)explosion2);
        }
        this.hurtNearby();
    }

    private void blueExplosion() {
        BlueStarExplosionCenter explosion2;
        BlueStarExplosion explosion = (BlueStarExplosion)((EntityType)CompanionsEntities.BLUE_STAR_EXPLOSION.get()).m_20615_(this.m_9236_());
        if (explosion != null) {
            explosion.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)explosion);
        }
        if ((explosion2 = (BlueStarExplosionCenter)((EntityType)CompanionsEntities.BLUE_STAR_EXPLOSION_CENTER.get()).m_20615_(this.m_9236_())) != null) {
            explosion2.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)explosion2);
        }
        this.hurtNearby();
    }

    private void hurtNearby() {
        for (LivingEntity e : this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20183_()).m_82400_(3.0))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this)) continue;
            e.m_6469_(this.m_269291_().m_269425_(), 7.0f);
            if (this.isRed()) {
                e.m_20254_(new Random().nextInt(2, 10));
                continue;
            }
            e.m_146917_(e.m_146888_() + new Random().nextInt(60, 200));
        }
    }

    public boolean isRed() {
        return (Boolean)this.f_19804_.m_135370_(RED);
    }

    public void setRed(boolean isRed) {
        this.f_19804_.m_135381_(RED, (Object)isRed);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        entity.m_6469_(damageSource, (float)CompanionsConfig.HOLINESS_STAR_DAMAGE);
        this.m_5496_(SoundEvents.f_11892_, 5.0f, 1.0f);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RED, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Red")) {
            this.setRed(pCompound.m_128471_("Red"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Red", this.isRed());
    }

    public void m_6123_(@NotNull Player pEntity) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

