/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StakeProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Quaternionf prevRot = new Quaternionf();
    private final Quaternionf currentRot = new Quaternionf();

    public StakeProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = false;
    }

    public StakeProjectile(Level pLevel, LivingEntity pShooter) {
        super((EntityType)CompanionsEntities.STAKE_PROJECTILE.get(), pShooter, pLevel);
        this.f_19794_ = false;
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public void m_8119_() {
        Vec3 velocity = this.m_20184_();
        if (velocity.m_82556_() > 1.0E-7) {
            this.prevRot.set((Quaternionfc)this.currentRot);
            Vector3f velVec = new Vector3f((float)velocity.f_82479_, (float)velocity.f_82480_, (float)velocity.f_82481_);
            velVec.normalize();
            Vector3f defaultForward = new Vector3f(0.0f, 0.0f, -1.0f);
            float dot = defaultForward.dot((Vector3fc)velVec);
            dot = Math.max(-1.0f, Math.min(1.0f, dot));
            float angle = (float)Math.acos(dot);
            Vector3f axis = defaultForward.cross((Vector3fc)velVec);
            if (axis.length() < 1.0E-4f) {
                axis.set(0.0f, 1.0f, 0.0f);
            } else {
                axis.normalize();
            }
            Quaternionf targetRotation = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, angle);
            this.currentRot.set((Quaternionfc)targetRotation);
        }
        super.m_8119_();
    }

    public Quaternionf getPrevRotation() {
        return this.prevRot;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRot;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }
}

