/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class StoneSpikeProjectile
extends BaseProjectile {
    private final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");

    public StoneSpikeProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= this.getLifetime()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.f_19797_ == 5) {
            if (!this.m_9236_().f_46443_) {
                this.spawnParticles();
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12446_, this.m_5720_(), 1.0f, 1.0f);
        }
        List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.3), e -> !e.equals((Object)this.m_19749_()));
        for (LivingEntity e2 : entities) {
            if (Util.areEntitiesLinked((Entity)e2, (Entity)this)) continue;
            e2.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.STONE_SPIKE_DAMAGE);
            Random random = new Random();
            if (!(random.nextFloat() < 0.25f) || e2.m_21023_(MobEffects.f_19614_)) continue;
            e2.m_7292_(new MobEffectInstance(MobEffects.f_19614_, new Random().nextInt(20, 100), 0, true, true, true));
        }
    }

    private void spawnParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double dx = (sv.m_213780_().m_188500_() - 0.5) * 0.1;
                double dy = (sv.m_213780_().m_188500_() - 0.5) * 0.1;
                double dz = (sv.m_213780_().m_188500_() - 0.5) * 0.1;
                sv.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.0);
            }
        }
    }

    public void m_6123_(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 36;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.APPEAR);
        return PlayState.CONTINUE;
    }
}

