/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.companion.MankhEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LaserTriggerProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(LaserTriggerProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity target;

    public LaserTriggerProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        this.f_19804_.m_135381_(TARGET_ID, (Object)target.m_19879_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
    }

    public int getTargetId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ID);
    }

    @Override
    protected int baseLifetime() {
        return 60;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof MankhEntity) {
            MankhEntity mankh = (MankhEntity)entity;
            if (this.target == null && !this.m_9236_().f_46443_) {
                int id = (Integer)this.f_19804_.m_135370_(TARGET_ID);
                Entity e2 = this.m_9236_().m_6815_(id);
                if (e2 instanceof LivingEntity) {
                    this.target = (LivingEntity)e2;
                }
            }
            if (this.target != null) {
                Vec3 mankhPos = mankh.m_146892_();
                Vec3 targetPos = this.target.m_146892_();
                Vec3 directionToTarget = targetPos.m_82546_(mankhPos).m_82541_();
                double dx = directionToTarget.f_82479_;
                double dy = directionToTarget.f_82480_;
                double dz = directionToTarget.f_82481_;
                float yaw = (float)(Math.atan2(-dx, dz) * 180.0 / Math.PI);
                float pitch = (float)(Math.asin(-dy) * 180.0 / Math.PI);
                mankh.m_146922_(yaw);
                mankh.m_146926_(pitch);
                Vec3 alpha = mankh.m_20182_().m_82520_(0.0, (double)mankh.m_20206_() * 0.5, 0.0).m_82549_(directionToTarget.m_82490_(0.05));
                this.m_6027_(alpha.f_82479_, alpha.f_82480_, alpha.f_82481_);
                this.m_146922_(yaw);
                this.m_146926_(pitch);
            }
        }
        if (!this.m_9236_().f_46443_ && this.target != null) {
            Vec3 start = this.m_20182_();
            Vec3 targetPos = this.target.m_146892_();
            BlockHitResult hit = this.m_9236_().m_45547_(new ClipContext(start, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 end = hit.m_6662_() == HitResult.Type.BLOCK && !this.m_9236_().m_8055_(hit.m_82425_()).m_60812_((BlockGetter)this.m_9236_(), hit.m_82425_()).m_83281_() ? hit.m_82450_() : targetPos;
            AABB bb = new AABB(start, end).m_82400_(0.25);
            List entities = this.m_9236_().m_6443_(LivingEntity.class, bb, e -> !Util.areEntitiesLinked((Entity)this, (Entity)e));
            for (LivingEntity e3 : entities) {
                Entity entity2 = this.m_19749_();
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity2;
                le.m_7327_((Entity)e3);
                e3.m_20256_(e3.m_20184_().m_82542_(0.05, 0.5, 0.05));
            }
        }
        if (this.m_9236_().f_46443_) {
            Companions.PROXY.tickLaserTriggerProjectile(this);
        }
    }

    public void spawnSparks(Level level) {
        double y = this.m_20182_().f_82480_ + (double)(this.m_20206_() * 0.5f);
        for (int i = 0; i < 360; i += 120) {
            double angleRadians = Math.toRadians(i);
            double x = this.m_20182_().f_82479_ + 0.35 * Math.cos(angleRadians);
            double z = this.m_20182_().f_82481_ + 0.35 * Math.sin(angleRadians);
            level.m_7106_((ParticleOptions)CompanionsParticles.LASER_SPARK.get(), x, y, z, 0.0, 0.15, 0.0);
        }
    }
}

