/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.EmberPoleApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionSummonFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsSummonHurtTargetGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EmberPoleEntity
extends CompanionSummonEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation EXPLODE = RawAnimation.begin().thenPlay("explode");
    private static final EntityDataAccessor<Boolean> IS_EXPLODING = SynchedEntityData.m_135353_(EmberPoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ANIMATION_EXPLODE_TICKS = 55;
    private int explodeCounter = -1;

    public EmberPoleEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public void setIsExploding(boolean exploding) {
        this.f_19804_.m_135381_(IS_EXPLODING, (Object)exploding);
    }

    public boolean isExploding() {
        return (Boolean)this.f_19804_.m_135370_(IS_EXPLODING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_EXPLODING, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 9.0) {
                this.setIsExploding(true);
            }
            if (this.isExploding() && this.explodeCounter == -1) {
                this.explodeCounter = 0;
            }
            this.setNoMovement(this.isExploding());
            this.explode();
            if (this.explodeCounter >= 0) {
                ++this.explodeCounter;
                if (this.explodeCounter == 2) {
                    this.m_5496_(SoundEvents.f_11892_, 0.75f, 1.0f);
                } else if (this.explodeCounter >= 55) {
                    this.m_146870_();
                }
            }
        }
    }

    private void explode() {
        if (this.explodeCounter == 3) {
            for (int i = 0; i < 20; ++i) {
                double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                if (level2.f_46441_.m_188501_() < 0.7f) {
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 1, dx, dy, dz, 0.1);
                }
                if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
                level2.m_8767_((ParticleOptions)CompanionsParticles.EMBER_POLE_EXPLOSION.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 1.5, this.m_20189_(), 1, dx, dy, dz, 0.08);
            }
            for (LivingEntity e : this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20183_()).m_82400_(3.0))) {
                if (Util.areEntitiesLinked((Entity)e, (Entity)this)) continue;
                this.m_7327_((Entity)e);
                Random random = new Random();
                if (!((double)random.nextFloat() < 0.75)) continue;
                e.m_20254_(new Random().nextInt(3, 10));
            }
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.SMALL_FROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.SMALL_FROG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.SMALL_FROG_IDLE.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EmberPoleApproachTargetGoal(this, 0.45, 0.4f, 1.25f));
        this.f_21345_.m_25352_(3, (Goal)new CompanionSummonFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsSummonHurtTargetGoal(this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isExploding()) {
            event.setAnimation(this.EXPLODE);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

