/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ShadowBellItem
extends TooltipItem {
    private static final String ST_DIM = "stored_dim";
    private static final String ST_X = "stored_x";
    private static final String ST_Y = "stored_y";
    private static final String ST_Z = "stored_z";
    private static final String BELL_CURR = "bell_curr";
    private static final String BELL_MAX = "bell_max";
    private static final String UUID_SHADE = "cached_shade";
    private static final String ALTAR_NAME = "altar_name";

    public ShadowBellItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag t = stack.m_41783_();
        return t != null && t.m_128441_(BELL_CURR) && t.m_128441_(BELL_MAX);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        CompoundTag t = stack.m_41783_();
        int curr = t != null ? t.m_128451_(BELL_CURR) : 0;
        int max = t != null ? t.m_128451_(BELL_MAX) : 1;
        return Math.round((float)curr * 13.0f / (float)max);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 0xAA0077;
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        String currName;
        BlockEntity blockEntity;
        ServerLevel maybe;
        if (!(pEntity instanceof Player)) {
            return;
        }
        if (pLevel.f_46443_) {
            return;
        }
        CompoundTag tag = pStack.m_41783_();
        if (tag == null || !tag.m_128441_(ST_DIM)) {
            return;
        }
        ServerLevel altarLevel = null;
        if (pLevel.m_7654_() != null && (maybe = pLevel.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(ST_DIM))))) instanceof ServerLevel) {
            altarLevel = maybe;
        }
        BlockPos pos = new BlockPos(tag.m_128451_(ST_X), tag.m_128451_(ST_Y), tag.m_128451_(ST_Z));
        if (altarLevel == null || !((blockEntity = altarLevel.m_7702_(pos)) instanceof AbstractShadeAltarBlockEntity)) {
            this.clearLink(pStack);
            return;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
        if (altar.getCharges() <= 0) {
            return;
        }
        if (tag.m_128451_(BELL_CURR) != altar.getCharges() || tag.m_128451_(BELL_MAX) != altar.getMaxCharges()) {
            tag.m_128405_(BELL_CURR, altar.getCharges());
            tag.m_128405_(BELL_MAX, altar.getMaxCharges());
            pStack.m_41751_(tag);
        }
        if (!(currName = altarLevel.m_8055_(pos).m_60734_().m_49954_().getString()).equals(tag.m_128461_(ALTAR_NAME))) {
            tag.m_128359_(ALTAR_NAME, currName);
            pStack.m_41751_(tag);
        }
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CompoundTag t = stack.m_41783_();
        if (!(t != null && t.m_128441_(ST_DIM) && t.m_128441_(ST_X) && t.m_128441_(ST_Y) && t.m_128441_(ST_Z))) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.item.companions.shadow_bell.default").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            return;
        }
        if (t.m_128441_(BELL_CURR) && t.m_128441_(ALTAR_NAME)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.item.companions.shadow_bell.linked_to", (Object[])new Object[]{t.m_128461_(ALTAR_NAME)}));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.item.companions.shadow_bell.charges_remaining", (Object[])new Object[]{t.m_128451_(BELL_CURR)}));
            if (t.m_128403_(UUID_SHADE)) {
                Entity e = CompanionsEntityTracker.getEntityByUUID(t.m_128342_(UUID_SHADE));
                if (e instanceof ShadeEntity) {
                    ShadeEntity shade = (ShadeEntity)e;
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.item.companions.shadow_bell.lifetime", (Object[])new Object[]{shade.getLifetime() / 20}));
                } else {
                    t.m_128473_(UUID_SHADE);
                    stack.m_41751_(t);
                }
            }
        }
    }

    @Override
    protected String tooltipName() {
        return "";
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractShadeAltarBlockEntity)) {
            if (ctx.m_43723_() != null) {
                return this.m_7203_(level, ctx.m_43723_(), ctx.m_43724_()).m_19089_();
            }
            return InteractionResult.PASS;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
        if (altar.getCharges() <= 0 && ctx.m_43723_() != null) {
            ctx.m_43723_().m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.altar_empty"), true);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(ST_DIM, level.m_46472_().m_135782_().toString());
        tag.m_128405_(ST_X, pos.m_123341_());
        tag.m_128405_(ST_Y, pos.m_123342_());
        tag.m_128405_(ST_Z, pos.m_123343_());
        tag.m_128405_(BELL_CURR, altar.getCharges());
        tag.m_128405_(BELL_MAX, altar.getMaxCharges());
        tag.m_128359_(ALTAR_NAME, level.m_8055_(pos).m_60734_().m_49954_().getString());
        stack.m_41751_(tag);
        if (ctx.m_43723_() != null) {
            ctx.m_43723_().m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.altar_saved"), true);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ShadeEntity shade;
        CompoundTag tag = pStack.m_41783_();
        if (tag != null && pInteractionTarget instanceof ShadeEntity && (shade = (ShadeEntity)pInteractionTarget).m_21805_() != null && shade.m_21805_().equals(pPlayer.m_20148_())) {
            pInteractionTarget.m_146870_();
            if (tag.m_128403_(UUID_SHADE) && pInteractionTarget.m_20148_().equals(tag.m_128342_(UUID_SHADE)) && pInteractionTarget instanceof ShadeEntity) {
                tag.m_128473_(UUID_SHADE);
                pStack.m_41751_(tag);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag tag = stack.m_41783_();
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!(tag != null && tag.m_128441_(ST_DIM) && tag.m_128441_(ST_X) && tag.m_128441_(ST_Y) && tag.m_128441_(ST_Z) && pLevel.m_7654_() != null)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ServerLevel world = pLevel.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(ST_DIM))));
        if (world == null) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.couldnt_find"), true);
            this.clearLink(stack);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockEntity blockEntity = world.m_7702_(new BlockPos(tag.m_128451_(ST_X), tag.m_128451_(ST_Y), tag.m_128451_(ST_Z)));
        if (blockEntity instanceof AbstractShadeAltarBlockEntity) {
            ShadeEntity entity;
            AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
            if (altar.getCharges() <= 0) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.no_charges"), true);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            UUID oldShadeUUID = altar.activeShadeUUID;
            if (oldShadeUUID != null) {
                Entity oldShade = world.m_8791_(oldShadeUUID);
                if (oldShade instanceof ShadeEntity) {
                    oldShade.m_146870_();
                }
                altar.activeShadeUUID = null;
            }
            if ((entity = altar.spawnShade(pPlayer.m_9236_(), pPlayer, pUsedHand, this)) != null) {
                tag.m_128362_(UUID_SHADE, entity.m_20148_());
                stack.m_41751_(tag);
            }
            if (altar.consumeCharge()) {
                altar.sync();
                tag.m_128405_(BELL_CURR, altar.getCharges());
                stack.m_41751_(tag);
            } else {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.no_charges"), true);
                this.clearLink(stack);
            }
            pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), CompanionsSounds.SHADE_BELL_SUMMON.get(), pPlayer.m_5720_(), 0.3f, 1.0f);
        } else {
            this.clearLink(stack);
            pPlayer.m_5661_((Component)Component.m_237115_((String)"shadow_bell.companions.client_message.couldnt_find"), true);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
    }

    private void clearLink(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_(ST_DIM);
        tag.m_128473_(ST_X);
        tag.m_128473_(ST_Y);
        tag.m_128473_(ST_Z);
        tag.m_128473_(BELL_CURR);
        tag.m_128473_(BELL_MAX);
        tag.m_128473_(UUID_SHADE);
        tag.m_128473_(ALTAR_NAME);
        stack.m_41751_(tag);
    }
}

