/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.BigIceShardProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceShardBook
extends AbstractMagicBook {
    public IceShardBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "ice_shard_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player player, @NotNull InteractionHand pUsedHand) {
        if (!pLevel.f_46443_) {
            BigIceShardProjectile projectile = (BigIceShardProjectile)((EntityType)CompanionsEntities.BIG_ICE_SHARD_PROJECTILE.get()).m_20615_(pLevel);
            if (projectile != null) {
                Vec3 up;
                Vec3 forward = player.m_20154_().m_82541_();
                if (Math.abs(forward.m_82526_(up = new Vec3(0.0, 1.0, 0.0))) > 0.99) {
                    up = new Vec3(1.0, 0.0, 0.0);
                }
                Vec3 right = forward.m_82537_(up).m_82541_();
                double spawnX = player.m_20185_() + right.f_82479_ * 0.5 + up.f_82479_ * 0.5;
                double spawnY = player.m_20186_() + (double)player.m_20206_() + right.f_82480_ * 0.5 + up.f_82480_ * 0.5;
                double spawnZ = player.m_20189_() + right.f_82481_ * 0.5 + up.f_82481_ * 0.5;
                projectile.m_6027_(spawnX, spawnY, spawnZ);
                projectile.m_5602_((Entity)player);
                double angle = Math.toRadians(30.0);
                double cos = new Random().nextDouble() * (1.0 - Math.cos(angle)) + Math.cos(angle);
                double sin = Math.sqrt(1.0 - cos * cos);
                double phi = new Random().nextDouble() * 2.0 * Math.PI;
                projectile.m_20256_(forward.m_82490_(cos).m_82549_(right.m_82490_(sin * Math.cos(phi))).m_82549_(up.m_82490_(sin * Math.sin(phi))).m_82541_().m_82490_(0.2));
                LivingEntity e = player.m_21188_();
                projectile.setTarget(e == null ? player.m_21214_() : e);
                pLevel.m_7967_((Entity)projectile);
            }
            player.m_36335_().m_41524_((Item)this, (int)((double)CompanionsConfig.ICE_SHARD_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.m_7203_(pLevel, player, pUsedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), CompanionsSounds.SPELL_RELEASE_ICE.get(), player.m_5720_(), 1.0f, 1.0f);
    }
}

