/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class FireworkToadParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final int mode;

    FireworkToadParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z, velX, velY, velZ);
        this.spriteSet = sprites;
        this.f_107663_ = 0.15f;
        this.f_107225_ = new Random().nextInt(15) + 20;
        this.f_107226_ = 0.1f;
        this.f_107219_ = true;
        this.f_172258_ = 0.98f;
        this.mode = new Random().nextInt(3);
        this.m_108339_(sprites);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.spriteSet);
        switch (this.mode) {
            case 0: {
                this.m_107271_(this.f_107224_ % 4 < 2 ? 1.0f : 0.0f);
                break;
            }
            case 2: {
                this.m_107271_(0.0f);
                if (this.f_107224_ % 2 != 0) break;
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            float speed = 0.5f;
            int size = 1;
            ParticleEngine engine = Minecraft.m_91087_().f_91061_;
            Random r = new Random();
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double rx = (double)j + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double ry = (double)i + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double rz = (double)k + (r.nextDouble() - r.nextDouble()) * 0.5;
                        double norm = Math.sqrt(rx * rx + ry * ry + rz * rz) / (double)speed + r.nextGaussian() * 0.05;
                        FireworkToadParticle p = new FireworkToadParticle(level, x, y, z, this.sprites, rx /= norm, ry /= norm, rz /= norm);
                        p.m_107271_(0.99f);
                        engine.m_107344_((Particle)p);
                    }
                }
            }
            return null;
        }
    }
}

