/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.CroissantEggBlockEntity;
import dev.xylonity.companions.common.entity.companion.CroissantDragonEntity;
import dev.xylonity.companions.common.recipe.CroissantEggRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class CroissantEggRecipeCategory
implements IRecipeCategory<CroissantEggRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("companions", "croissant_egg_interaction");
    public static final RecipeType<CroissantEggRecipe> TYPE = new RecipeType(UID, CroissantEggRecipe.class);
    public static final ResourceLocation SHADOW = new ResourceLocation("companions", "textures/gui/sprites.png");
    private final IDrawable icon;
    private CroissantEggBlockEntity cachedBlockEntity;
    private CroissantDragonEntity cachedEntity;
    private long lastUpdateTime = 0L;

    public CroissantEggRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.CROISSANT_EGG.get()));
    }

    @NotNull
    public RecipeType<CroissantEggRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.companions.croissant_egg_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CroissantEggRecipe rec, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addItemStack(rec.input);
    }

    private CroissantEggBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new CroissantEggBlockEntity(BlockPos.f_121853_, CompanionsBlocks.CROISSANT_EGG.get().m_49966_());
        }
        return this.cachedBlockEntity;
    }

    private CroissantDragonEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = new CroissantDragonEntity((EntityType<? extends TamableAnimal>)((EntityType)CompanionsEntities.CROISSANT_DRAGON.get()), (Level)Minecraft.m_91087_().f_91073_);
            this.cachedEntity.setMilkAmount(3);
            this.cachedEntity.m_21557_(true);
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        if (this.cachedEntity != null) {
            this.cachedEntity.f_19797_ = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull CroissantEggRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.m_280218_(SHADOW, 12, 57, 0, 0, 39, 17);
        guiGraphics.m_280218_(SHADOW, 26, 10, 62, 56, 19, 29);
        guiGraphics.m_280218_(SHADOW, 60, 50, 81, 6, 39, 12);
        guiGraphics.m_280218_(SHADOW, 4, 4, 120, 0, 19, 19);
        guiGraphics.m_280218_(SHADOW, 68, 24, 111, 24, 21, 25);
        guiGraphics.m_280218_(SHADOW, 100, 50, 170, 0, 42, 25);
        this.updateAnimation();
        CroissantEggBlockEntity be = this.getOrCreateBlockEntity();
        CroissantDragonEntity maw = this.getOrCreateEntity();
        GeoBlockRenderer renderer = (GeoBlockRenderer)Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)be);
        GeoEntityRenderer mawRenderer = (GeoEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)maw);
        if (renderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource buffer = guiGraphics.m_280091_();
        pose.m_85836_();
        pose.m_252880_(25.0f, 65.0f, 20.0f);
        pose.m_85841_(20.0f, 20.0f, 20.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(160.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat = pose.m_85850_().m_252943_();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            renderer.m_6922_((BlockEntity)be, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        catch (Exception e) {
            renderer.m_6922_((BlockEntity)be, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(130.0f, 65.0f, 20.0f);
        pose.m_85841_(18.0f, 18.0f, 18.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(38.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat2 = pose.m_85850_().m_252943_();
        Vector3f up2 = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front2 = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            mawRenderer.m_7392_((Entity)maw, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        catch (Exception e) {
            mawRenderer.m_7392_((Entity)maw, 0.0f, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        pose.m_85849_();
        buffer.m_109911_();
    }
}

