/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.common.recipe.EmptyPuppetRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class PuppetRecipeCategory
implements IRecipeCategory<EmptyPuppetRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("companions", "puppet_interaction");
    public static final RecipeType<EmptyPuppetRecipe> TYPE = new RecipeType(UID, EmptyPuppetRecipe.class);
    public static final ResourceLocation SHADOW = new ResourceLocation("companions", "textures/gui/sprites.png");
    private final IDrawable icon;
    private PuppetGloveEntity cachedEntity;
    private PuppetEntity cachedEntity2;
    private long lastUpdateTime = 0L;

    public PuppetRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.EMPTY_PUPPET.get()));
    }

    @NotNull
    public RecipeType<EmptyPuppetRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.companions.puppet_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyPuppetRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        this.cachedEntity2 = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addItemStack(rec.input);
    }

    private PuppetGloveEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = new PuppetGloveEntity((EntityType<? extends TamableAnimal>)((EntityType)CompanionsEntities.PUPPET_GLOVE.get()), (Level)Minecraft.m_91087_().f_91073_);
            this.cachedEntity.m_21557_(true);
        }
        return this.cachedEntity;
    }

    private PuppetEntity getOrCreateEntity2() {
        if (this.cachedEntity2 == null) {
            this.cachedEntity2 = new PuppetEntity((EntityType<? extends TamableAnimal>)((EntityType)CompanionsEntities.PUPPET.get()), (Level)Minecraft.m_91087_().f_91073_);
            this.cachedEntity2.m_21557_(true);
        }
        return this.cachedEntity2;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        if (this.cachedEntity != null) {
            this.cachedEntity.f_19797_ = (int)(System.currentTimeMillis() / 50L);
        }
        if (this.cachedEntity2 != null) {
            this.cachedEntity2.f_19797_ = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull EmptyPuppetRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.m_280218_(SHADOW, 19, 62, 216, 5, 38, 16);
        guiGraphics.m_280218_(SHADOW, 26, 10, 62, 56, 19, 29);
        guiGraphics.m_280218_(SHADOW, 60, 50, 81, 6, 39, 12);
        guiGraphics.m_280218_(SHADOW, 4, 4, 120, 0, 19, 19);
        guiGraphics.m_280218_(SHADOW, 110, 62, 216, 5, 38, 16);
        this.updateAnimation();
        PuppetGloveEntity dragon1 = this.getOrCreateEntity();
        PuppetEntity dragon2 = this.getOrCreateEntity2();
        GeoEntityRenderer dragonRenderer1 = (GeoEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)dragon1);
        GeoEntityRenderer dragonRenderer2 = (GeoEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)dragon2);
        PoseStack pose = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource buffer = guiGraphics.m_280091_();
        pose.m_85836_();
        pose.m_252880_(40.0f, 68.0f, 20.0f);
        pose.m_85841_(17.0f, 17.0f, 17.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(38.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat = pose.m_85850_().m_252943_();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            dragonRenderer1.m_7392_((Entity)dragon1, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        catch (Exception e) {
            dragonRenderer1.m_7392_((Entity)dragon1, 0.0f, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(130.0f, 68.0f, 20.0f);
        pose.m_85841_(18.0f, 18.0f, 18.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(38.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat2 = pose.m_85850_().m_252943_();
        Vector3f up2 = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front2 = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            dragonRenderer2.m_7392_((Entity)dragon2, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        catch (Exception e) {
            dragonRenderer2.m_7392_((Entity)dragon2, 0.0f, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        pose.m_85849_();
        buffer.m_109911_();
    }
}

