/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class BeltHelper {
    public static Map<Item, Boolean> uprightCache = new Object2BooleanOpenHashMap();
    public static final ResourceManagerReloadListener LISTENER = resourceManager -> uprightCache.clear();

    public static boolean isItemUpright(ItemStack stack) {
        return uprightCache.computeIfAbsent(stack.m_41720_(), item -> {
            boolean isFluidHandler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
            boolean useUpright = AllTags.AllItemTags.UPRIGHT_ON_BELT.matches(stack);
            boolean forceDisableUpright = !AllTags.AllItemTags.NOT_UPRIGHT_ON_BELT.matches(stack);
            return (isFluidHandler || useUpright) && forceDisableUpright;
        });
    }

    public static BeltBlockEntity getSegmentBE(LevelAccessor world, BlockPos pos) {
        Level l;
        if (world instanceof Level && !(l = (Level)world).m_46749_(pos)) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)blockEntity;
    }

    public static BeltBlockEntity getControllerBE(LevelAccessor world, BlockPos pos) {
        BeltBlockEntity segment = BeltHelper.getSegmentBE(world, pos);
        if (segment == null) {
            return null;
        }
        BlockPos controllerPos = segment.controller;
        if (controllerPos == null) {
            return null;
        }
        return BeltHelper.getSegmentBE(world, controllerPos);
    }

    public static BeltBlockEntity getBeltForOffset(BeltBlockEntity controller, float offset) {
        return BeltHelper.getBeltAtSegment(controller, (int)Math.floor(offset));
    }

    public static BeltBlockEntity getBeltAtSegment(BeltBlockEntity controller, int segment) {
        BlockPos pos = BeltHelper.getPositionForOffset(controller, segment);
        BlockEntity be = controller.m_58904_().m_7702_(pos);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)be;
    }

    public static BlockPos getPositionForOffset(BeltBlockEntity controller, int offset) {
        BlockPos pos = controller.m_58899_();
        Vec3i vec = controller.getBeltFacing().m_122436_();
        BeltSlope slope = (BeltSlope)((Object)controller.m_58900_().m_61143_(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        return pos.m_7918_(offset * vec.m_123341_(), Mth.m_14045_((int)offset, (int)0, (int)(controller.beltLength - 1)) * verticality, offset * vec.m_123343_());
    }

    public static Vec3 getVectorForOffset(BeltBlockEntity controller, float offset) {
        BeltSlope slope = (BeltSlope)((Object)controller.m_58900_().m_61143_(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        float verticalMovement = verticality;
        if ((double)offset < 0.5) {
            verticalMovement = 0.0f;
        }
        verticalMovement *= Math.min(offset, (float)controller.beltLength - 0.5f) - 0.5f;
        Vec3 vec = VecHelper.getCenterOf((Vec3i)controller.m_58899_());
        Vec3 horizontalMovement = Vec3.m_82528_((Vec3i)controller.getBeltFacing().m_122436_()).m_82490_((double)(offset - 0.5f));
        if (slope == BeltSlope.VERTICAL) {
            horizontalMovement = Vec3.f_82478_;
        }
        vec = vec.m_82549_(horizontalMovement).m_82520_(0.0, (double)verticalMovement, 0.0);
        return vec;
    }

    public static Vec3 getBeltVector(BlockState state) {
        BeltSlope slope = (BeltSlope)((Object)state.m_61143_(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        Vec3 horizontalMovement = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122436_());
        if (slope == BeltSlope.VERTICAL) {
            return new Vec3(0.0, (double)((Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122421_().m_122540_(), 0.0);
        }
        return new Vec3(0.0, (double)verticality, 0.0).m_82549_(horizontalMovement);
    }
}

