/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.CurvedTrackDestroyPacket;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;

public class CurvedTrackInteraction {
    static final int breakerId = new Object().hashCode();
    static int breakTicks;
    static int breakTimeout;
    static float breakProgress;
    static BlockPos breakPos;

    public static void clientTick() {
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (!player.m_150110_().f_35938_) {
            return;
        }
        if (mc.f_91066_.f_92096_.m_90857_() && result != null) {
            breakPos = result.blockEntity().m_58899_();
            BlockState blockState = level.m_8055_(breakPos);
            if (blockState.m_60795_()) {
                CurvedTrackInteraction.resetBreakProgress();
                return;
            }
            if ((float)breakTicks % 4.0f == 0.0f) {
                SoundType soundtype = blockState.getSoundType((LevelReader)level, breakPos, (Entity)player);
                mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 8.0f, soundtype.m_56774_() * 0.5f, level.f_46441_, BlockPos.m_274446_((Position)result.vec())));
            }
            boolean creative = player.m_150110_().f_35937_;
            ++breakTicks;
            breakTimeout = 2;
            float f = creative ? 0.125f : blockState.m_60625_((Player)player, (BlockGetter)level, breakPos) / 8.0f;
            Vec3 vec = VecHelper.offsetRandomly((Vec3)result.vec(), (RandomSource)level.f_46441_, (float)0.25f);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            int progress = (int)((breakProgress += f) * 10.0f) - 1;
            level.m_6801_(player.m_19879_(), breakPos, progress);
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (breakProgress >= 1.0f) {
                AllPackets.getChannel().sendToServer((Object)new CurvedTrackDestroyPacket(breakPos, result.loc().curveTarget(), BlockPos.m_274446_((Position)result.vec()), false));
                CurvedTrackInteraction.resetBreakProgress();
            }
            return;
        }
        if (breakTimeout == 0) {
            return;
        }
        if (--breakTimeout > 0) {
            return;
        }
        CurvedTrackInteraction.resetBreakProgress();
    }

    private static void resetBreakProgress() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (breakPos != null && level != null) {
            level.m_6801_(mc.f_91074_.m_19879_(), breakPos, -1);
        }
        breakProgress = 0.0f;
        breakTicks = 0;
        breakPos = null;
    }

    public static boolean onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return false;
        }
        if (event.isUseItem()) {
            TrackTargetingBlockItem ttbi;
            ItemStack heldItem = player.m_21205_();
            Item item = heldItem.m_41720_();
            if (AllTags.AllBlockTags.TRACKS.matches(heldItem)) {
                player.m_5661_((Component)CreateLang.translateDirect("track.turn_start", new Object[0]).m_130940_(ChatFormatting.RED), true);
                player.m_6674_(InteractionHand.MAIN_HAND);
                return true;
            }
            if (item instanceof TrackTargetingBlockItem && (ttbi = (TrackTargetingBlockItem)item).useOnCurve(result, heldItem)) {
                player.m_6674_(InteractionHand.MAIN_HAND);
                return true;
            }
            if (AllItems.WRENCH.isIn(heldItem) && player.m_6144_()) {
                AllPackets.getChannel().sendToServer((Object)new CurvedTrackDestroyPacket(result.blockEntity().m_58899_(), result.loc().curveTarget(), BlockPos.m_274446_((Position)result.vec()), true));
                CurvedTrackInteraction.resetBreakProgress();
                player.m_6674_(InteractionHand.MAIN_HAND);
                return true;
            }
        }
        return event.isAttack();
    }
}

