/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config.gui;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import java.util.ArrayList;
import java.util.List;
import mod.crend.dynamiccrosshair.config.gui.CrosshairButton;
import mod.crend.dynamiccrosshair.config.gui.DrawCrosshairWidget;
import mod.crend.dynamiccrosshair.config.gui.SelectCrosshairController;
import mod.crend.dynamiccrosshair.style.AbstractCrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SelectCrosshairElement
extends AbstractWidget
implements ContainerEventHandler {
    static final int BUTTON_SIZE = 23;
    static final int BUTTON_SPACING = 25;
    static final int BUTTONS_PER_ROW = 9;
    static final int BIG_BUTTON_WIDTH = 45;
    final SelectCrosshairController control;
    GuiEventListener focusedElement;
    boolean dragging;
    int normalHeight;
    List<GuiEventListener> childrenInSelectMode = new ArrayList<GuiEventListener>();
    List<GuiEventListener> childrenInEditMode = new ArrayList<GuiEventListener>();
    List<Renderable> drawableInSelectMode = new ArrayList<Renderable>();
    List<Renderable> drawableInEditMode = new ArrayList<Renderable>();
    Button addButton;
    Button editButton;
    Button deleteButton;
    Button saveButton;
    Button cancelButton;
    DrawCrosshairWidget drawCrosshairWidget;

    public boolean canReset() {
        return true;
    }

    public SelectCrosshairElement(SelectCrosshairController selectCrosshairController, Dimension<Integer> widgetDimension) {
        super(widgetDimension);
        this.normalHeight = (Integer)widgetDimension.height();
        this.control = selectCrosshairController;
        this.createButtons();
        this.toggleButtons();
        this.updateFromSelectedStyle((ResourceLocation)this.control.option().pendingValue());
        this.control.option().addListener((opt, style) -> this.updateFromSelectedStyle((ResourceLocation)style));
    }

    private <T extends GuiEventListener & Renderable> void addSelectModeChild(T element) {
        this.childrenInSelectMode.add(element);
        this.drawableInSelectMode.add(element);
    }

    private <T extends GuiEventListener & Renderable> void addEditModeChild(T element) {
        this.childrenInEditMode.add(element);
        this.drawableInEditMode.add(element);
    }

    private <T extends GuiEventListener & Renderable> void addChild(T element) {
        this.addSelectModeChild(element);
        this.addEditModeChild(element);
    }

    private void createButtons() {
        int x = (Integer)this.getDimension().x();
        int y = (Integer)this.getDimension().y() + 25 + 2;
        this.addButton = Button.m_253074_((Component)Component.m_237115_((String)"dynamiccrosshair.add"), button -> {
            this.control.add();
            this.toggleButtons();
        }).m_252987_(x, y, 43, 20).m_253136_();
        this.editButton = Button.m_253074_((Component)Component.m_237115_((String)"dynamiccrosshair.edit"), button -> {
            if (this.control.isCustomStyle()) {
                this.control.edit();
                this.toggleButtons();
            }
        }).m_252987_(x + 45, y, 43, 20).m_253136_();
        this.deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"dynamiccrosshair.delete"), button -> {
            if (this.control.isCustomStyle()) {
                this.control.delete();
                this.toggleButtons();
            }
        }).m_252987_(x + 90, y, 43, 20).m_253136_();
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"dynamiccrosshair.save"), button -> {
            this.control.save();
            this.toggleButtons();
        }).m_252987_(x + 135, y, 43, 20).m_253136_();
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"dynamiccrosshair.cancel"), button -> {
            this.control.cancel();
            this.toggleButtons();
        }).m_252987_(x + 180, y, 43, 20).m_253136_();
    }

    private void resetButtons() {
        this.childrenInSelectMode.clear();
        this.childrenInEditMode.clear();
        this.drawableInSelectMode.clear();
        this.drawableInEditMode.clear();
        this.addChild(this.addButton);
        this.addChild(this.editButton);
        this.addChild(this.deleteButton);
        this.addChild(this.saveButton);
        this.addChild(this.cancelButton);
        List<AbstractCrosshairStyle> styles = this.control.getButtons();
        int n = 2 + styles.size() / 9 + (styles.size() % 9 == 0 ? 0 : 1);
        this.setDimension(this.getDimension().withHeight((Number)(this.normalHeight * n)));
        int x = (Integer)this.getDimension().x();
        int y = 50;
        this.drawCrosshairWidget = new DrawCrosshairWidget((Dimension<Integer>)Dimension.ofInt((int)(x + 90), (int)(y + 10), (int)45, (int)45), this.control);
        this.addEditModeChild(this.drawCrosshairWidget);
        int buttonI = 0;
        for (AbstractCrosshairStyle style : styles) {
            this.addSelectModeChild(new CrosshairButton(this.control, style, (Dimension<Integer>)Dimension.ofInt((int)x, (int)y, (int)23, (int)23)));
            x += 25;
            if (++buttonI != 9) continue;
            buttonI = 0;
            x = (Integer)this.getDimension().x();
            y += 25;
        }
    }

    public void toggleButtons() {
        boolean canEditSelectedStyle;
        this.resetButtons();
        boolean editMode = this.control.editStyle != null;
        this.addButton.f_93623_ = !editMode;
        this.editButton.f_93623_ = canEditSelectedStyle = !editMode && CrosshairStyleManager.INSTANCE.isCustomStyle((ResourceLocation)this.control.option.pendingValue());
        this.deleteButton.f_93623_ = canEditSelectedStyle;
        this.saveButton.f_93623_ = editMode;
        this.cancelButton.f_93623_ = editMode;
    }

    public void updateFromSelectedStyle(ResourceLocation identifier) {
        boolean isCustomStyle;
        this.editButton.f_93623_ = isCustomStyle = CrosshairStyleManager.INSTANCE.isCustomStyle(identifier);
        this.deleteButton.f_93623_ = isCustomStyle;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.control.editStyle == null) {
            for (Renderable drawable : this.drawableInSelectMode) {
                drawable.m_88315_(context, mouseX, mouseY, delta);
            }
        } else {
            for (Renderable drawable : this.drawableInEditMode) {
                drawable.m_88315_(context, mouseX, mouseY, delta);
            }
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.control.editStyle == null ? this.childrenInSelectMode : this.childrenInEditMode;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            if (button == 0 || button == 1) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        return this.m_94729_(mouseX, mouseY).filter(element -> element.m_6348_(mouseX, mouseY, button)).isPresent();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7282_() && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focusedElement;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (this.focusedElement != null) {
            this.focusedElement.m_93692_(false);
        }
        if (focused != null) {
            focused.m_93692_(true);
        }
        this.focusedElement = focused;
    }

    @Nullable
    public ComponentPath m_264435_() {
        return super.m_264435_();
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent navigation) {
        return super.m_264064_(navigation);
    }
}

