/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiLog;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class StackBatcher {
    private static MethodHandle sodiumSpriteHandle;
    private static boolean isIncompatibleSodiumLoaded;
    private final BatcherVertexConsumerProvider imm;
    private final MultiBufferSource unlitFacade;
    private final Map<RenderType, VertexBuffer> buffers = new LinkedHashMap<RenderType, VertexBuffer>();
    private final Set<TextureAtlasSprite> spritesToUpdate = Sets.newHashSet();
    private boolean populated = false;
    private boolean dirty = false;
    private int x;
    private int y;
    private int z;
    public static final List<RenderType> EXTRA_RENDER_LAYERS;

    public static boolean isEnabled() {
        return EmiConfig.useBatchedRenderer && !isIncompatibleSodiumLoaded;
    }

    public StackBatcher() {
        HashMap<RenderType, BufferBuilder> buffers = new HashMap<RenderType, BufferBuilder>();
        this.assign(buffers, RenderType.m_110451_());
        this.assign(buffers, RenderType.m_110463_());
        this.assign(buffers, RenderType.m_110466_());
        this.assign(buffers, Sheets.m_110789_());
        this.assign(buffers, Sheets.m_110790_());
        this.assign(buffers, Sheets.m_110792_());
        this.assign(buffers, RenderType.m_110490_());
        this.assign(buffers, RenderType.m_110493_());
        this.assign(buffers, RenderType.m_110496_());
        for (RenderType layer : EXTRA_RENDER_LAYERS) {
            this.assign(buffers, layer);
        }
        this.imm = new BatcherVertexConsumerProvider(new BufferBuilder(256), buffers);
        this.unlitFacade = new UnlitFacade(this.imm);
    }

    private void assign(Map<RenderType, BufferBuilder> buffers, RenderType layer) {
        buffers.put(layer, new BufferBuilder(layer.m_110507_()));
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void repopulate() {
        this.dirty = true;
    }

    public void begin(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (this.dirty) {
            this.populated = false;
            this.dirty = false;
            this.spritesToUpdate.clear();
        }
    }

    public void render(Batchable batchable, GuiGraphics draw, int x, int y, float delta) {
        if (!this.populated) {
            try {
                batchable.renderForBatch(batchable.isSideLit() ? this.imm : this.unlitFacade, draw, x - this.x, y + this.y, this.z, delta);
            }
            catch (Throwable t) {
                if (EmiConfig.devMode) {
                    EmiLog.error("Batchable threw exception during batched rendering. See log for info", t);
                }
                batchable.setUnbatchable();
            }
        }
    }

    public void render(EmiIngredient stack, GuiGraphics draw, int x, int y, float delta) {
        this.render(stack, draw, x, y, delta, -3);
    }

    public void render(EmiIngredient stack, GuiGraphics draw, int x, int y, float delta, int flags) {
        Batchable b;
        if (stack instanceof Batchable && !(b = (Batchable)((Object)stack)).isUnbatchable() && StackBatcher.isEnabled() && (flags & 1) != 0) {
            if (!this.populated) {
                try {
                    b.renderForBatch(b.isSideLit() ? this.imm : this.unlitFacade, draw, x - this.x, -y - this.y, this.z, delta);
                    if (sodiumSpriteHandle != null && !stack.isEmpty()) {
                        ItemStack is = stack.getEmiStacks().get(0).getItemStack();
                        Minecraft client = Minecraft.m_91087_();
                        BakedModel model = client.m_91291_().m_115103_().m_109406_(is);
                        if (model != null) {
                            List<BakedQuad> quads = EmiPort.getQuads(model);
                            for (BakedQuad quad : quads) {
                                if (quad == null) continue;
                                this.spritesToUpdate.add(quad.m_173410_());
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    if (EmiConfig.devMode) {
                        EmiLog.error("Stack threw exception during batched rendering. See log for info", t);
                    }
                    b.setUnbatchable();
                }
            }
            stack.render(draw, x, y, delta, flags & 0xFFFFFFFE);
        } else {
            stack.render(draw, x, y, delta, flags);
        }
    }

    public void draw() {
        if (!StackBatcher.isEnabled()) {
            return;
        }
        if (sodiumSpriteHandle != null) {
            try {
                for (TextureAtlasSprite sprite : this.spritesToUpdate) {
                    sodiumSpriteHandle.invoke(sprite);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.populated) {
            this.bake();
            this.populated = true;
        }
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        Matrix4f mat = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        mat.mul((Matrix4fc)new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        mat.mul((Matrix4fc)new Matrix4f().translation((float)this.x, (float)(-this.y - 16), 0.0f));
        for (Map.Entry<RenderType, VertexBuffer> en : this.buffers.entrySet()) {
            en.getKey().m_110185_();
            EmiPort.setShader(en.getValue(), mat);
            en.getKey().m_110188_();
        }
        BufferUploader.m_166835_();
    }

    private void bake() {
        this.imm.drawCurrentLayer();
        this.buffers.values().forEach(VertexBuffer::close);
        this.buffers.clear();
        for (RenderType layer : this.imm.getLayerBuffers().keySet()) {
            this.bake(layer);
        }
    }

    public void bake(RenderType layer) {
        BufferBuilder bldr = this.imm.getBufferInternal(layer);
        if (!this.imm.getActiveConsumers().remove(bldr)) {
            return;
        }
        VertexBuffer vb = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        EmiPort.upload(vb, bldr);
        this.buffers.put(layer, vb);
        bldr.m_85730_();
    }

    static {
        block10: {
            try {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("net.caffeinemc.sodium.render.texture.SpriteUtil");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (clazz == null) {
                    clazz = Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil");
                }
                if ((sodiumSpriteHandle = MethodHandles.lookup().findStatic(clazz, "markSpriteActive", MethodType.methodType(Void.TYPE, TextureAtlasSprite.class))) != null) {
                    EmiLog.info("Discovered Sodium");
                }
                if (!EmiAgnos.isModLoaded("sodium") && !EmiAgnos.isModLoaded("rubidium")) break block10;
                try {
                    Class.forName("net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter");
                }
                catch (Throwable t) {
                    try {
                        Class.forName("me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter");
                        isIncompatibleSodiumLoaded = true;
                        EmiLog.info("Batching stack renderer disabled for compatibility with legacy Sodium");
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        EXTRA_RENDER_LAYERS = Lists.newArrayList();
    }

    private static class BatcherVertexConsumerProvider
    implements MultiBufferSource {
        protected final BufferBuilder fallbackBuffer;
        protected final Map<RenderType, BufferBuilder> layerBuffers;
        protected Optional<RenderType> currentLayer = Optional.empty();
        protected final Set<BufferBuilder> activeConsumers = Sets.newHashSet();

        protected BatcherVertexConsumerProvider(BufferBuilder fallbackBuffer, Map<RenderType, BufferBuilder> layerBuffers) {
            this.fallbackBuffer = fallbackBuffer;
            this.layerBuffers = layerBuffers;
        }

        public VertexConsumer m_6299_(RenderType renderLayer) {
            Optional optional = renderLayer.m_110406_();
            BufferBuilder bufferBuilder = this.getBufferInternal(renderLayer);
            if (!Objects.equals(this.currentLayer, optional)) {
                RenderType renderLayer2;
                if (this.currentLayer.isPresent() && !this.layerBuffers.containsKey(renderLayer2 = this.currentLayer.get())) {
                    this.draw(renderLayer2);
                }
                if (this.activeConsumers.add(bufferBuilder)) {
                    bufferBuilder.m_166779_(renderLayer.m_173186_(), renderLayer.m_110508_());
                }
                this.currentLayer = optional;
            }
            return bufferBuilder;
        }

        private BufferBuilder getBufferInternal(RenderType layer) {
            return this.layerBuffers.getOrDefault(layer, this.fallbackBuffer);
        }

        public void drawCurrentLayer() {
            if (this.currentLayer.isPresent()) {
                RenderType renderLayer = this.currentLayer.get();
                if (!this.layerBuffers.containsKey(renderLayer)) {
                    this.draw(renderLayer);
                }
                this.currentLayer = Optional.empty();
            }
        }

        public void draw(RenderType layer) {
            BufferBuilder bufferBuilder = this.getBufferInternal(layer);
            boolean bl = Objects.equals(this.currentLayer, layer.m_110406_());
            if (!bl && bufferBuilder == this.fallbackBuffer) {
                return;
            }
            if (!this.activeConsumers.remove(bufferBuilder)) {
                return;
            }
            layer.m_276775_(bufferBuilder, VertexSorting.f_276633_);
            if (bl) {
                this.currentLayer = Optional.empty();
            }
        }

        public Map<RenderType, BufferBuilder> getLayerBuffers() {
            return this.layerBuffers;
        }

        public Set<BufferBuilder> getActiveConsumers() {
            return this.activeConsumers;
        }
    }

    private static class UnlitFacade
    implements MultiBufferSource {
        private final MultiBufferSource delegate;
        private final IdentityHashMap<VertexConsumer, VertexConsumer> cache = new IdentityHashMap();

        public UnlitFacade(MultiBufferSource delegate) {
            this.delegate = delegate;
        }

        public VertexConsumer m_6299_(RenderType layer) {
            return this.cache.computeIfAbsent(this.delegate.m_6299_(layer), Consumer::new);
        }

        private static final class Consumer
        implements VertexConsumer {
            private final VertexConsumer delegate;

            private Consumer(VertexConsumer delegate) {
                this.delegate = delegate;
            }

            public VertexConsumer m_5601_(float x, float y, float z) {
                this.delegate.m_5601_(0.0f, 1.0f, 0.0f);
                return this;
            }

            public VertexConsumer m_5483_(double x, double y, double z) {
                this.delegate.m_5483_(x, y, z);
                return this;
            }

            public void m_141991_() {
                this.delegate.m_141991_();
            }

            public VertexConsumer m_7421_(float u, float v) {
                this.delegate.m_7421_(u, v);
                return this;
            }

            public VertexConsumer m_7122_(int u, int v) {
                this.delegate.m_7122_(u, v);
                return this;
            }

            public void m_5752_() {
                this.delegate.m_5752_();
            }

            public VertexConsumer m_7120_(int u, int v) {
                this.delegate.m_7120_(u, v);
                return this;
            }

            public void m_7404_(int r, int g, int b, int a) {
                this.delegate.m_7404_(r, g, b, a);
            }

            public VertexConsumer m_6122_(int r, int g, int b, int a) {
                this.delegate.m_6122_(r, g, b, a);
                return this;
            }
        }
    }

    public static interface Batchable {
        public boolean isSideLit();

        public boolean isUnbatchable();

        public void setUnbatchable();

        public void renderForBatch(MultiBufferSource var1, GuiGraphics var2, int var3, int var4, int var5, float var6);
    }

    public static class ClaimedCollection {
        private Set<StackBatcher> claimed = Sets.newHashSet();
        private List<StackBatcher> unclaimed = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StackBatcher claim() {
            ClaimedCollection claimedCollection = this;
            synchronized (claimedCollection) {
                StackBatcher batcher = this.unclaimed.isEmpty() ? new StackBatcher() : this.unclaimed.remove(this.unclaimed.size() - 1);
                if (batcher == null) {
                    batcher = new StackBatcher();
                }
                this.claimed.add(batcher);
                return batcher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unclaim(StackBatcher batcher) {
            ClaimedCollection claimedCollection = this;
            synchronized (claimedCollection) {
                this.claimed.remove(batcher);
                this.unclaimed.add(batcher);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unclaimAll() {
            ClaimedCollection claimedCollection = this;
            synchronized (claimedCollection) {
                for (StackBatcher batcher : this.claimed) {
                    this.unclaimed.add(batcher);
                }
                this.claimed.clear();
            }
        }
    }
}

