/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util.stack;

import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class EmiStackWithTitle
extends EmiStack {
    protected final ResourceLocation id;
    private final TrimmedTitle name;
    private final MutableComponent rawName;

    public EmiStackWithTitle(ResourceLocation id, String unknownNamespace, String unknownPath, EMILoot.Type type, int width, ChatFormatting ... formatting) {
        this.id = id;
        this.rawName = this.getRawTitle(id, unknownNamespace, unknownPath, type);
        this.name = TrimmedTitle.of((Component)this.rawName.m_6881_().m_130944_(formatting), width);
    }

    protected MutableComponent getRawTitle(ResourceLocation id, String unknownNamespace, String unknownPath, EMILoot.Type type) {
        MutableComponent rawTitle;
        String key = String.join((CharSequence)".", "emi_loot", unknownNamespace, id.toString());
        if (!I18n.m_118936_((String)key)) {
            String[] chestPathTokens;
            StringBuilder chestName = new StringBuilder();
            for (String str : chestPathTokens = id.m_135815_().split("[/_]")) {
                if (LText.tablePrefixes.contains(str)) continue;
                if (!chestName.isEmpty()) {
                    chestName.append(" ");
                }
                if (str.length() <= 1) {
                    chestName.append(str);
                    continue;
                }
                chestName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
            }
            if (EMILootAgnos.isModLoaded(id.m_135827_())) {
                rawTitle = LText.translatable(this.getUnknownModdedKey(unknownNamespace, unknownPath), chestName.toString());
            } else {
                MutableComponent unknown = LText.translatable(this.getUnknownKey(unknownNamespace));
                rawTitle = LText.translatable(this.getUnknownModdedKey(unknownNamespace, unknownPath), LText.literal(chestName.toString()).m_130946_(" ").m_7220_((Component)unknown));
            }
            if (EMILoot.config.isLogI18n(type)) {
                EMILoot.LOGGER.warn("Untranslated " + unknownNamespace + " loot table \"" + String.valueOf(id) + "\" (key: \"" + key + "\")");
            }
        } else {
            rawTitle = LText.translatable(key);
        }
        return rawTitle;
    }

    private String getUnknownModdedKey(String namespace, String path) {
        return String.join((CharSequence)".", "emi_loot", namespace, path);
    }

    private String getUnknownKey(String namespace) {
        return String.join((CharSequence)".", "emi_loot", namespace, "unknown");
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
    }

    public boolean isEmpty() {
        return false;
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.getId().toString();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<Component> getTooltipText() {
        return List.of();
    }

    public Component getName() {
        return this.rawName.m_6881_();
    }

    public FormattedCharSequence getTrimmedName() {
        return this.name.title();
    }

    public boolean isTrimmed() {
        return this.name.trimmed();
    }
}

