/*
 * Decompiled with CFR 0.152.
 */
package com.worldswanderer.ethercondenser;

import com.worldswanderer.ethercondenser.EtherCondenserBlockEntity;
import com.worldswanderer.ethercondenser.EtherCondenserMod;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EtherCondenserMenu
extends AbstractContainerMenu {
    private final EtherCondenserBlockEntity blockEntity;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public EtherCondenserMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, EtherCondenserMenu.getBlockEntity(playerInventory, extraData));
    }

    public EtherCondenserMenu(int containerId, Inventory inventory, final EtherCondenserBlockEntity blockEntity) {
        this(containerId, inventory, blockEntity, new ContainerData(){

            public int m_6413_(int index) {
                return blockEntity != null ? blockEntity.progress : 0;
            }

            public void m_8050_(int index, int value) {
                if (blockEntity != null) {
                    blockEntity.progress = value;
                }
            }

            public int m_6499_() {
                return 1;
            }
        });
    }

    public EtherCondenserMenu(int containerId, Inventory inventory, EtherCondenserBlockEntity blockEntity, ContainerData data) {
        super((MenuType)EtherCondenserMod.ETHER_CONDENSER_MENU.get(), containerId);
        int i;
        this.blockEntity = blockEntity;
        this.data = data;
        this.access = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.itemHandler, 0, 56, 35){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42692_);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.itemHandler, 1, 116, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38884_(data);
    }

    private static EtherCondenserBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        if (data == null) {
            throw new IllegalArgumentException("Extra data is null!");
        }
        BlockPos blockPos = data.m_130135_();
        Level level = playerInventory.f_35978_.m_9236_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof EtherCondenserBlockEntity)) {
            throw new IllegalStateException("Block entity is not EtherCondenserBlockEntity at " + String.valueOf(blockPos));
        }
        return (EtherCondenserBlockEntity)blockEntity;
    }

    public boolean isWorking() {
        return this.data.m_6413_(0) > 0;
    }

    public int getProgressScaled(int scale) {
        return this.data.m_6413_(0) * scale / 100;
    }

    public int getChunkLoadPercent() {
        return this.blockEntity != null ? this.blockEntity.getChunkLoadPercent() : 0;
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_7702_(pos) == this.blockEntity, (Object)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!sourceStack.m_150930_(Items.f_42692_)) return ItemStack.f_41583_;
            if (!this.m_38903_(sourceStack, 36, 37, false)) {
                return ItemStack.f_41583_;
            }
        } else if (!this.m_38903_(sourceStack, 0, 36, true)) {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSourceStack;
    }
}

