/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.inputfield;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.inputfield.InputFieldEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.inputfield.InputFieldElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputFieldElementBuilder
extends ElementBuilder<InputFieldElement, InputFieldEditorElement> {
    public InputFieldElementBuilder() {
        super("fancymenu_customization_item_input_field");
    }

    @Override
    @NotNull
    public InputFieldElement buildDefaultInstance() {
        InputFieldElement e = new InputFieldElement(this);
        e.baseWidth = 100;
        e.baseHeight = 20;
        e.editBox = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, e.getAbsoluteX(), e.getAbsoluteY(), e.getAbsoluteWidth(), e.getAbsoluteHeight(), (Component)Component.m_237119_());
        e.editBox.setCharacterFilter(e.type.filter);
        return e;
    }

    @Override
    @NotNull
    public InputFieldElement deserializeElement(@NotNull SerializedElement serialized) {
        String maxLengthString;
        InputFieldElement.InputFieldType t;
        InputFieldElement element = this.buildDefaultInstance();
        element.linkedVariable = serialized.getValue("linked_variable");
        String inputFieldTypeString = serialized.getValue("input_field_type");
        if (inputFieldTypeString != null && (t = InputFieldElement.InputFieldType.getByName(inputFieldTypeString)) != null) {
            element.type = t;
        }
        if ((maxLengthString = serialized.getValue("max_text_length")) != null && MathUtils.isInteger((String)maxLengthString)) {
            element.maxTextLength = Integer.parseInt(maxLengthString);
        }
        if (element.maxTextLength <= 0) {
            element.maxTextLength = 1;
        }
        element.editBox = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, element.getAbsoluteX(), element.getAbsoluteY(), element.getAbsoluteWidth(), element.getAbsoluteHeight(), (Component)Component.m_237119_());
        element.editBox.setCharacterFilter(element.type.filter);
        element.editBox.m_94199_(element.maxTextLength);
        if (element.linkedVariable != null && VariableHandler.variableExists(element.linkedVariable)) {
            String var = Objects.requireNonNull(VariableHandler.getVariable(element.linkedVariable)).getValue();
            element.editBox.m_94144_(var);
        }
        element.navigatable = this.deserializeBoolean(element.navigatable, serialized.getValue("navigatable"));
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull InputFieldElement element, @NotNull SerializedElement serializeTo) {
        if (element.linkedVariable != null) {
            serializeTo.putProperty("linked_variable", element.linkedVariable);
        }
        serializeTo.putProperty("input_field_type", element.type.getName());
        serializeTo.putProperty("max_text_length", "" + element.maxTextLength);
        serializeTo.putProperty("navigatable", "" + element.navigatable);
        return serializeTo;
    }

    @Override
    @NotNull
    public InputFieldEditorElement wrapIntoEditorElement(@NotNull InputFieldElement element, @NotNull LayoutEditorScreen editor) {
        return new InputFieldEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"fancymenu.elements.input_field");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.input_field.desc", new String[0]);
    }
}

