/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.button;

import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxButton
extends ExtendedButton {
    public static final ResourceLocation CHECKBOX_BACKGROUND_TEXTURE_NORMAL_DEFAULT = new ResourceLocation("fancymenu", "textures/widgets/checkbox/background_normal.png");
    public static final ResourceLocation CHECKBOX_BACKGROUND_TEXTURE_HOVER_DEFAULT = new ResourceLocation("fancymenu", "textures/widgets/checkbox/background_hover.png");
    public static final ResourceLocation CHECKBOX_BACKGROUND_TEXTURE_INACTIVE_DEFAULT = new ResourceLocation("fancymenu", "textures/widgets/checkbox/background_inactive.png");
    public static final ResourceLocation CHECKBOX_CHECKMARK_TEXTURE_DEFAULT = new ResourceLocation("fancymenu", "textures/widgets/checkbox/checkmark.png");
    protected boolean checkboxState = false;
    @NotNull
    protected StateChangedAction onStateChanged;
    @Nullable
    protected ITexture customCheckmarkTexture = null;
    @Nullable
    protected ITexture customBackgroundTextureNormal = null;
    @Nullable
    protected ITexture customBackgroundTextureHover = null;
    @Nullable
    protected ITexture customBackgroundTextureInactive = null;

    public CheckboxButton(int x, int y, int width, int height, @NotNull StateChangedAction onStateChanged) {
        super(x, y, width, height, (Component)Component.m_237119_(), button -> {});
        this.onStateChanged = onStateChanged;
        this.setPressAction(button -> {
            this.checkboxState = !this.checkboxState;
            onStateChanged.onStateChanged(this, this.checkboxState);
        });
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.m_87963_(graphics, mouseX, mouseY, partial);
        if (this.checkboxState && this.m_142518_()) {
            graphics.m_280163_(this.getCheckboxCheckmarkTexture(), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
        }
    }

    @Override
    protected void renderBackground(@NotNull GuiGraphics graphics) {
        graphics.m_280163_(this.getCheckboxBackground(), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
    }

    @Override
    protected void renderLabelText(@NotNull GuiGraphics graphics) {
    }

    @NotNull
    public ResourceLocation getCheckboxCheckmarkTexture() {
        ResourceLocation loc;
        if (this.customCheckmarkTexture != null && (loc = this.customCheckmarkTexture.getResourceLocation()) != null) {
            return loc;
        }
        return CHECKBOX_CHECKMARK_TEXTURE_DEFAULT;
    }

    public void setCustomCheckboxCheckmarkTexture(@Nullable ITexture customCheckmarkTexture) {
        this.customCheckmarkTexture = customCheckmarkTexture;
    }

    public void setCustomBackgroundTextureNormal(@Nullable ITexture customBackgroundTextureNormal) {
        this.customBackgroundTextureNormal = customBackgroundTextureNormal;
    }

    public void setCustomBackgroundTextureHover(@Nullable ITexture customBackgroundTextureHover) {
        this.customBackgroundTextureHover = customBackgroundTextureHover;
    }

    public void setCustomBackgroundTextureInactive(@Nullable ITexture customBackgroundTextureInactive) {
        this.customBackgroundTextureInactive = customBackgroundTextureInactive;
    }

    @NotNull
    public ResourceLocation getCheckboxBackground() {
        if (!this.m_142518_()) {
            return this.getCheckboxBackgroundTextureInactive();
        }
        if (this.m_198029_()) {
            return this.getCheckboxBackgroundTextureHover();
        }
        return this.getCheckboxBackgroundTextureNormal();
    }

    @NotNull
    public ResourceLocation getCheckboxBackgroundTextureNormal() {
        ResourceLocation loc;
        if (this.customBackgroundTextureNormal != null && (loc = this.customBackgroundTextureNormal.getResourceLocation()) != null) {
            return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_NORMAL_DEFAULT;
    }

    @NotNull
    public ResourceLocation getCheckboxBackgroundTextureHover() {
        ResourceLocation loc;
        if (this.customBackgroundTextureHover != null && (loc = this.customBackgroundTextureHover.getResourceLocation()) != null) {
            return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_HOVER_DEFAULT;
    }

    @NotNull
    public ResourceLocation getCheckboxBackgroundTextureInactive() {
        ResourceLocation loc;
        if (this.customBackgroundTextureInactive != null && (loc = this.customBackgroundTextureInactive.getResourceLocation()) != null) {
            return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_INACTIVE_DEFAULT;
    }

    public boolean getCheckboxState() {
        return this.checkboxState;
    }

    public void setCheckboxState(boolean state, boolean callOnStateChanged) {
        this.checkboxState = state;
        if (callOnStateChanged) {
            this.onStateChanged.onStateChanged(this, this.checkboxState);
        }
    }

    @FunctionalInterface
    public static interface StateChangedAction {
        public void onStateChanged(@NotNull CheckboxButton var1, boolean var2);
    }
}

