/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.video.mcef;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoManager;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long JS_RESULT_TIMEOUT_MS = 1000L;
    protected volatile WrappedMCEFBrowser browser;
    protected volatile float volume = 1.0f;
    protected volatile boolean looping = false;
    protected volatile boolean fillScreen = false;
    protected volatile String currentVideoPath = null;
    protected volatile boolean isMuted = false;
    protected volatile int posX = 0;
    protected volatile int posY = 0;
    protected volatile int width = 200;
    protected volatile int height = 200;
    protected volatile boolean initialized = false;
    private final String instanceId = UUID.randomUUID().toString();

    public MCEFVideoPlayer() {
        this.initialize();
    }

    public MCEFVideoPlayer(int x, int y, int width, int height) {
        this.posX = x;
        this.posY = y;
        this.width = width;
        this.height = height;
        this.initialize();
    }

    public void initialize() {
        if (!MCEFUtil.isMCEFLoaded()) {
            LOGGER.error("[FANCYMENU] Failed to initialize MCEFVideoPlayer: MCEF is not loaded");
            return;
        }
        MCEFVideoManager.getInstance().initialize();
        try {
            String playerUrl = this.buildPlayerUrl();
            File playerFile = new File(FancyMenu.TEMP_DATA_DIR, "web/videoplayer/player.html");
            if (!playerFile.exists()) {
                LOGGER.warn("[FANCYMENU] Player HTML file not found. Attempting to extract resources.");
                MCEFVideoManager.getInstance().initialize();
                if (!playerFile.exists()) {
                    LOGGER.error("[FANCYMENU] CRITICAL: Player HTML file does not exist at: " + playerFile.getAbsolutePath() + ". Video player will fail.");
                    return;
                }
            }
            this.browser = WrappedMCEFBrowser.build(playerUrl, false, false, this.posX, this.posY, this.width, this.height, success -> {
                if (success.booleanValue()) {
                    this.initialized = true;
                } else {
                    LOGGER.error("[FANCYMENU] Failed to initialize MCEFVideoPlayer for browser with ID: " + (this.browser != null ? this.browser.getIdentifier() : "unknown"));
                    this.initialized = false;
                }
            });
            if (this.browser != null) {
                this.browser.setAutoPlayAllVideosOnLoad(false);
                this.browser.setMuteAllMediaOnLoad(false);
            } else {
                LOGGER.error("[FANCYMENU] MCEFVideoPlayer: Browser was not created successfully. Player will not function.");
                this.initialized = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Failed to initialize MCEFVideoPlayer [{}]", (Object)this.instanceId, (Object)e);
            this.initialized = false;
        }
    }

    protected String buildPlayerUrl() {
        File playerFile = new File(FancyMenu.TEMP_DATA_DIR, "web/videoplayer/player.html");
        String basePath = playerFile.toURI().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("volume", String.valueOf(this.volume));
        params.put("loop", String.valueOf(this.looping));
        params.put("fillScreen", String.valueOf(this.fillScreen));
        params.put("autoPlay", "false");
        return basePath + "?" + this.buildQueryString(params);
    }

    protected String buildQueryString(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return result.toString();
    }

    private void executeWhenInitialized(@NotNull Runnable task) {
        MCEFVideoPlayer.executeWithCondition(task, () -> this.initialized && this.browser != null && this.browser.getBrowser() != null);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.browser != null && this.initialized) {
            this.browser.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    public void loadVideo(@NotNull String videoPath) {
        this.executeWhenInitialized(() -> {
            this.currentVideoPath = videoPath;
            String escapedVideoPath = videoPath.replace("\\", "\\\\").replace("'", "\\'");
            String script = String.format("if(window.videoPlayerAPI && window.videoPlayerAPI.loadVideo) { window.videoPlayerAPI.loadVideo('%s'); } else { console.error('[FANCYMENU] videoPlayerAPI.loadVideo not found!'); }", escapedVideoPath);
            this.executeJavaScript(script);
        });
    }

    public void play() {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI && window.videoPlayerAPI.play) { window.videoPlayerAPI.play(); } else { console.error('[FANCYMENU] videoPlayerAPI.play not found!'); }"));
    }

    public void pause() {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI && window.videoPlayerAPI.pause) { window.videoPlayerAPI.pause(); } else { console.error('[FANCYMENU] videoPlayerAPI.pause not found!'); }"));
    }

    public void togglePlayPause() {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI && window.videoPlayerAPI.togglePlayPause) { window.videoPlayerAPI.togglePlayPause(); } else { console.error('[FANCYMENU] videoPlayerAPI.togglePlayPause not found!'); }"));
    }

    public void stop() {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI && window.videoPlayerAPI.stop) { window.videoPlayerAPI.stop(); } else { console.error('[FANCYMENU] videoPlayerAPI.stop not found!'); }"));
    }

    public void setMuted(boolean muted) {
        this.isMuted = muted;
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) { window.videoPlayerAPI.setMuted(" + muted + "); }"));
    }

    public boolean getMuted() {
        return this.isMuted;
    }

    public void toggleMuted() {
        this.setMuted(!this.getMuted());
    }

    public void setVolume(float volume) {
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) { window.videoPlayerAPI.setVolume(" + this.volume + "); }"));
    }

    public float getVolume() {
        return this.volume;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) { window.videoPlayerAPI.setLoop(" + looping + "); }"));
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setFillScreen(boolean fillScreen) {
        this.fillScreen = fillScreen;
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) { window.videoPlayerAPI.setFillScreen(" + fillScreen + "); }"));
    }

    public boolean isFillScreen() {
        return this.fillScreen;
    }

    public double getDuration() {
        if (!this.initialized) {
            return 0.0;
        }
        String jsCode = "(function() { try { var dur = window.videoPlayerAPI.getDuration(); return (dur === undefined || dur === null || isNaN(dur)) ? 0 : dur; } catch(e) { console.error('Error in getDuration:', e); return 0; } })()";
        String result = this.executeJavaScriptWithResult(jsCode);
        if (result == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Could not parse duration from JS result: '{}'. JS Code: {}", (Object)this.instanceId, (Object)result, (Object)jsCode);
            return 0.0;
        }
    }

    public long getDurationMillis() {
        return (long)(this.getDuration() * 1000.0);
    }

    public double getCurrentTime() {
        if (!this.initialized) {
            return 0.0;
        }
        String jsCode = "(function() { try { var time = window.videoPlayerAPI.getCurrentTime(); return (time === undefined || time === null || isNaN(time)) ? 0 : time; } catch(e) { console.error('Error in getCurrentTime:', e); return 0; } })()";
        String result = this.executeJavaScriptWithResult(jsCode);
        if (result == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Could not parse current time from JS result: '{}'. JS Code: {}", (Object)this.instanceId, (Object)result, (Object)jsCode);
            return 0.0;
        }
    }

    public long getCurrentTimeMillis() {
        return (long)(this.getCurrentTime() * 1000.0);
    }

    public void setCurrentTime(double seconds) {
        double secondsFinal = Math.max(0.0, seconds);
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) { window.videoPlayerAPI.setCurrentTime(" + secondsFinal + "); }"));
    }

    public void setCurrentTimeMillis(long milliseconds) {
        this.setCurrentTime((double)milliseconds / 1000.0);
    }

    public void seekForward(double seconds) {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) {   var currentTime = window.videoPlayerAPI.getCurrentTime();  var duration = window.videoPlayerAPI.getDuration();  window.videoPlayerAPI.setCurrentTime(Math.min(currentTime + " + seconds + ", duration));}"));
    }

    public void seekBackward(double seconds) {
        this.executeWhenInitialized(() -> this.executeJavaScript("if(window.videoPlayerAPI) {   var currentTime = window.videoPlayerAPI.getCurrentTime();  window.videoPlayerAPI.setCurrentTime(Math.max(currentTime - " + seconds + ", 0));}"));
    }

    public String getFormattedCurrentTime() {
        return this.formatTime(this.getCurrentTime());
    }

    public String getFormattedDuration() {
        return this.formatTime(this.getDuration());
    }

    public String getDetailedFormattedCurrentTime() {
        return this.formatTimeDetailed(this.getCurrentTime());
    }

    public String getDetailedFormattedDuration() {
        return this.formatTimeDetailed(this.getDuration());
    }

    public String getFormattedTimeInfo() {
        return this.getFormattedCurrentTime() + " / " + this.getFormattedDuration();
    }

    public String getDetailedFormattedTimeInfo() {
        return this.getDetailedFormattedCurrentTime() + " / " + this.getDetailedFormattedDuration();
    }

    public int getProgressPercentage() {
        double duration = this.getDuration();
        if (duration <= 0.0) {
            return 0;
        }
        return (int)(this.getCurrentTime() / duration * 100.0);
    }

    protected String formatTime(double seconds) {
        int totalSeconds = (int)Math.floor(seconds);
        int minutes = totalSeconds / 60;
        int remainingSeconds = totalSeconds % 60;
        return String.format("%d:%02d", minutes, remainingSeconds);
    }

    protected String formatTimeDetailed(double seconds) {
        int totalSeconds = (int)Math.floor(seconds);
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int remainingSeconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%d:%02d:%02d", hours, minutes, remainingSeconds);
        }
        return String.format("%d:%02d", minutes, remainingSeconds);
    }

    public boolean isPlaying() {
        if (!this.initialized) {
            return false;
        }
        String jsCode = "(function() { try { return !!(window.videoPlayerAPI && window.videoPlayerAPI.isPlaying()); } catch(e) { console.error('Error in isPlaying:', e); return false; } })()";
        String result = this.executeJavaScriptWithResult(jsCode);
        if (result == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(result);
        }
        catch (Exception e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Could not parse isPlaying state from JS result: '{}'. JS Code: {}", (Object)this.instanceId, (Object)result, (Object)jsCode, (Object)e);
            return false;
        }
    }

    public int getVideoWidth() {
        if (!this.initialized) {
            return 0;
        }
        String jsCode = "(function() { try { var w = window.videoPlayerAPI.getVideoWidth(); return (w === undefined || w === null || isNaN(w)) ? 0 : w; } catch(e) { console.error('Error in getVideoWidth:', e); return 0; } })()";
        String result = this.executeJavaScriptWithResult(jsCode);
        if (result == null) {
            return 0;
        }
        try {
            return (int)Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Could not parse video width from JS result: '{}'. JS Code: {}", (Object)this.instanceId, (Object)result, (Object)jsCode);
            return 0;
        }
    }

    public int getVideoHeight() {
        if (!this.initialized) {
            return 0;
        }
        String jsCode = "(function() { try { var h = window.videoPlayerAPI.getVideoHeight(); return (h === undefined || h === null || isNaN(h)) ? 0 : h; } catch(e) { console.error('Error in getVideoHeight:', e); return 0; } })()";
        String result = this.executeJavaScriptWithResult(jsCode);
        if (result == null) {
            return 0;
        }
        try {
            return (int)Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Could not parse video height from JS result: '{}'. JS Code: {}", (Object)this.instanceId, (Object)result, (Object)jsCode);
            return 0;
        }
    }

    public void setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.executeWhenInitialized(() -> this.browser.m_264152_(x, y));
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.executeWhenInitialized(() -> this.browser.setSize(width, height));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setOpacity(float opacity) {
        float finalOpacity = Math.max(0.0f, Math.min(1.0f, opacity));
        this.executeWhenInitialized(() -> {
            if (this.browser != null) {
                this.browser.setOpacity(finalOpacity);
            }
        });
    }

    @Nullable
    public WrappedMCEFBrowser getBrowser() {
        return this.browser;
    }

    protected void executeJavaScript(String code) {
        if (this.browser != null && this.browser.getBrowser() != null && this.initialized) {
            try {
                this.browser.getBrowser().executeJavaScript(code, this.browser.getUrl(), 0);
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Player [{}]: Error executing JavaScript: {}", (Object)this.instanceId, (Object)e.getMessage(), (Object)e);
            }
        } else {
            String reason = this.browser == null ? "browser is null" : (!this.initialized ? "initialized is false" : "underlying MCEF browser is null");
            LOGGER.warn("[FANCYMENU] Player [{}]: Attempted to execute JS when not ready. Reason: {}. Code: {}", (Object)this.instanceId, (Object)reason, (Object)code.substring(0, Math.min(50, code.length())));
        }
    }

    @Nullable
    protected String executeJavaScriptWithResult(String jsCodeToEvaluate) {
        if (this.browser == null || !this.initialized) {
            LOGGER.warn("[FANCYMENU] Player [{}]: executeJavaScriptWithResult called when not ready (browser null or not initialized).", (Object)this.instanceId);
            return null;
        }
        if (this.browser.getBrowser() == null) {
            LOGGER.warn("[FANCYMENU] Player [{}]: executeJavaScriptWithResult called but underlying MCEF browser is null.", (Object)this.instanceId);
            return null;
        }
        String requestId = UUID.randomUUID().toString();
        CompletableFuture resultFuture = new CompletableFuture();
        MCEFVideoManager.getPendingJsResults().put(requestId, resultFuture);
        String script = String.format("try {  var evalResult = (%s);  console.log('MCEF_ASYNC_RESULT:%s:' + JSON.stringify(evalResult));} catch (e) {  console.error('MCEF_ASYNC_RESULT:%s:' + JSON.stringify({error: e.toString(), message: e.message, stack: e.stack}));}", jsCodeToEvaluate, requestId, requestId);
        try {
            this.browser.getBrowser().executeJavaScript(script, this.browser.getUrl(), 0);
            String result = (String)resultFuture.get(1000L, TimeUnit.MILLISECONDS);
            if (result != null && result.contains("\"error\":")) {
                LOGGER.warn("[FANCYMENU] Player [{}]: JavaScript execution for request {} resulted in an error. JS Response: {}", (Object)this.instanceId, (Object)requestId, (Object)result);
                return null;
            }
            return result;
        }
        catch (TimeoutException e) {
            LOGGER.warn("[FANCYMENU] Player [{}]: Timeout ({}ms) waiting for JavaScript result for request {}. Original log: Could not get JavaScript result after multiple attempts", (Object)this.instanceId, (Object)1000L, (Object)requestId);
            MCEFVideoManager.getPendingJsResults().remove(requestId);
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("[FANCYMENU] Player [{}]: executeJavaScriptWithResult interrupted for request {}", (Object)this.instanceId, (Object)requestId, (Object)e);
            MCEFVideoManager.getPendingJsResults().remove(requestId);
            return null;
        }
        catch (ExecutionException e) {
            LOGGER.error("[FANCYMENU] Player [{}]: JavaScript execution future completed exceptionally for request {}", (Object)this.instanceId, (Object)requestId, (Object)e.getCause());
            MCEFVideoManager.getPendingJsResults().remove(requestId);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Player [{}]: Unexpected error in executeJavaScriptWithResult for request {}", (Object)this.instanceId, (Object)requestId, (Object)e);
            MCEFVideoManager.getPendingJsResults().remove(requestId);
            return null;
        }
    }

    public void dispose() {
        this.stop();
        if (this.browser != null) {
            try {
                this.browser.close();
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Player [{}]: Error closing MCEFVideoPlayer browser", (Object)this.instanceId, (Object)e);
            }
        }
        this.browser = null;
        this.initialized = false;
    }

    protected static void executeWithCondition(@NotNull Runnable task, @NotNull Supplier<Boolean> condition) {
        ScheduledFuture[] futureHolder = new ScheduledFuture[1];
        ObjectHolder<Boolean> executed = ObjectHolder.of(false);
        futureHolder[0] = MCEFVideoManager.EXECUTOR.scheduleAtFixedRate(() -> {
            if (!((Boolean)executed.get()).booleanValue() && ((Boolean)condition.get()).booleanValue()) {
                task.run();
                futureHolder[0].cancel(true);
                executed.set(true);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }
}

