/*
 * Decompiled with CFR 0.152.
 */
package net.skilful_kit.harmfulsmoke;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.skilful_kit.harmfulsmoke.block.TobaccoPlantBlock;
import net.skilful_kit.harmfulsmoke.block.WildTobaccoPlantBlock;
import net.skilful_kit.harmfulsmoke.effects.StrongTobaccoExposureEffect;
import net.skilful_kit.harmfulsmoke.effects.TobaccoExposureEffect;
import net.skilful_kit.harmfulsmoke.item.AlmostFinishedCigarItem;
import net.skilful_kit.harmfulsmoke.item.AlmostFinishedCigaretteItem;
import net.skilful_kit.harmfulsmoke.item.CigarItem;
import net.skilful_kit.harmfulsmoke.item.CigaretteButtItem;
import net.skilful_kit.harmfulsmoke.item.CigaretteItem;
import net.skilful_kit.harmfulsmoke.item.DecoCigarItem;
import net.skilful_kit.harmfulsmoke.item.DecoCigaretteItem;
import net.skilful_kit.harmfulsmoke.item.DriedTobaccoLeavesItem;
import net.skilful_kit.harmfulsmoke.item.FilterForCigarettesItem;
import net.skilful_kit.harmfulsmoke.item.HalfSmokedCigarItem;
import net.skilful_kit.harmfulsmoke.item.LighterItem;
import net.skilful_kit.harmfulsmoke.item.LitCigarItem;
import net.skilful_kit.harmfulsmoke.item.LitCigaretteItem;
import net.skilful_kit.harmfulsmoke.item.PackOfCigarettesItem;
import net.skilful_kit.harmfulsmoke.item.ShreddedTobaccoItem;
import net.skilful_kit.harmfulsmoke.item.TobaccoLeavesItem;
import net.skilful_kit.harmfulsmoke.world.inventory.PackOfCigarettesMenu;
import org.slf4j.Logger;

@Mod(value="harmfulsmoke")
public class HarmfulsmokeMod {
    public static final String MODID = "harmfulsmoke";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"harmfulsmoke");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"harmfulsmoke");
    public static final DeferredRegister<MenuType<?>> GUI = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"harmfulsmoke");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"harmfulsmoke");
    public static final RegistryObject<Item> CIGARETTE = ITEMS.register("cigarette", CigaretteItem::new);
    public static final RegistryObject<Item> LIGHTER = ITEMS.register("lighter", LighterItem::new);
    public static final RegistryObject<Item> TOBACCO_LEAVES = ITEMS.register("tobacco_leaf", TobaccoLeavesItem::new);
    public static final RegistryObject<Item> DRIED_TOBACCO_LEAVES = ITEMS.register("dried_tobacco_leaf", DriedTobaccoLeavesItem::new);
    public static final RegistryObject<Item> FILTER_FOR_CIGARETTE = ITEMS.register("filter_for_cigarettes", FilterForCigarettesItem::new);
    public static final RegistryObject<Item> CIGARETTE_BUTT = ITEMS.register("cigarette_butt", CigaretteButtItem::new);
    public static final RegistryObject<Item> LIT_CIGARETTE = ITEMS.register("lit_cigarette", LitCigaretteItem::new);
    public static final RegistryObject<Item> ALMOST_FINISHED_CIGARETTE = ITEMS.register("almost_finished_cigarette", AlmostFinishedCigaretteItem::new);
    public static final RegistryObject<Item> CIGAR = ITEMS.register("cigar", CigarItem::new);
    public static final RegistryObject<Item> LIT_CIGAR = ITEMS.register("lit_cigar", LitCigarItem::new);
    public static final RegistryObject<Item> HALF_SMOKED_CIGAR = ITEMS.register("half-smoked_cigar", HalfSmokedCigarItem::new);
    public static final RegistryObject<Item> ALMOST_FINISHED_CIGAR = ITEMS.register("almost_finished_cigar", AlmostFinishedCigarItem::new);
    public static final RegistryObject<Item> DECO_CIGARETTE_HELMET = ITEMS.register("deco_cigarette", () -> new DecoCigaretteItem.Helmet());
    public static final RegistryObject<Item> DECO_CIGAR_HELMET = ITEMS.register("deco_cigar", () -> new DecoCigarItem.Helmet());
    public static final RegistryObject<MobEffect> TOBACCO_EXPOSURE = EFFECTS.register("tobacco_exposure", TobaccoExposureEffect::new);
    public static final RegistryObject<MobEffect> STRONG_TOBACCO_EXPOSURE = EFFECTS.register("strong_tobacco_exposure", StrongTobaccoExposureEffect::new);
    public static final RegistryObject<Block> TOBACCO_PLANT = BLOCKS.register("tobacco_plant", () -> new TobaccoPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_().m_284180_(MapColor.f_283765_)));
    public static final RegistryObject<Item> TOBACCO_SEEDS = ITEMS.register("tobacco_seeds", () -> new ItemNameBlockItem((Block)TOBACCO_PLANT.get(), new Item.Properties()));
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"harmfulsmoke");
    public static final RegistryObject<MenuType<PackOfCigarettesMenu>> PACK_OF_CIGARETTES_GUI = GUI.register("pack_of_cigarettes_gui", () -> IForgeMenuType.create(PackOfCigarettesMenu::new));
    public static final RegistryObject<Item> PACK_OF_CIGARETTES = ITEMS.register("pack_of_cigarettes", PackOfCigarettesItem::new);
    public static final RegistryObject<Block> WILD_TOBACCO_PLANT = BLOCKS.register("wild_tobacco_plant", WildTobaccoPlantBlock::new);
    public static final RegistryObject<Item> WILD_TOBACCO_PLANT_ITEM = ITEMS.register("wild_tobacco_plant", () -> new BlockItem((Block)WILD_TOBACCO_PLANT.get(), new Item.Properties()));
    public static final RegistryObject<Item> SHREDDED_TOBACCO = ITEMS.register("shredded_tobacco", ShreddedTobaccoItem::new);
    public static final RegistryObject<CreativeModeTab> HARMFUL_SMOKE = CREATIVE_MODE_TABS.register("harmful_smoke", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.harmful_smoke")).m_257737_(() -> ((Item)CIGARETTE.get()).m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)FILTER_FOR_CIGARETTE.get());
        output.m_246326_((ItemLike)TOBACCO_SEEDS.get());
        output.m_246326_((ItemLike)TOBACCO_LEAVES.get());
        output.m_246326_((ItemLike)DRIED_TOBACCO_LEAVES.get());
        output.m_246326_((ItemLike)SHREDDED_TOBACCO.get());
        output.m_246326_((ItemLike)CIGAR.get());
        output.m_246326_((ItemLike)CIGARETTE.get());
        output.m_246326_((ItemLike)DECO_CIGARETTE_HELMET.get());
        output.m_246326_((ItemLike)DECO_CIGAR_HELMET.get());
        output.m_246326_((ItemLike)PACK_OF_CIGARETTES.get());
        output.m_246326_((ItemLike)LIGHTER.get());
    }).m_257652_());

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        HarmfulsmokeMod.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public HarmfulsmokeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        GUI.register(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        EFFECTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == HARMFUL_SMOKE.getKey()) {
            event.accept(CIGARETTE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="harmfulsmoke", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            HARMFUL_SMOKE.get();
        }
    }
}

