/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.anchor;

import com.example.junctionmod.anchor.AnchorManager;
import com.example.junctionmod.anchor.SpatialAnchorBlockEntity;
import com.example.junctionmod.tertserskill.ITertserSkill;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.tertserskill.TertserSkillSyncPacket;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SpatialAnchorBlock
extends BaseEntityBlock {
    private static final Capability<ITertserSkill> SKILL_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITertserSkill>(){});

    public SpatialAnchorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60978_(5.0f).m_60955_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpatialAnchorBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.f_46443_ && placer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)placer;
            if (AnchorManager.isTooClose(level, pos)) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u26a0 \u041d\u0435\u043b\u044c\u0437\u044f \u0441\u0442\u0430\u0432\u0438\u0442\u044c \u042f\u043a\u043e\u0440\u044f \u0442\u0430\u043a \u0431\u043b\u0438\u0437\u043a\u043e \u0434\u0440\u0443\u0433 \u043a \u0434\u0440\u0443\u0433\u0443! (\u041c\u0438\u043d. 100 \u0431\u043b\u043e\u043a\u043e\u0432)"), true);
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                if (!player.m_7500_()) {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)this));
                }
                return;
            }
            player.getCapability(SKILL_CAP).ifPresent(skill -> {
                int levelNum = skill.getCurrentLevel();
                int owned = skill.getOwnedAnchorsCount();
                int baseLimit = 0;
                if (levelNum >= 10) {
                    baseLimit = 3;
                } else if (levelNum >= 6) {
                    baseLimit = 2;
                } else if (levelNum >= 3) {
                    baseLimit = 1;
                }
                int bonusLimit = player.getPersistentData().m_128451_("JunctionBonusAnchors");
                int totalLimit = baseLimit + bonusLimit;
                if (owned >= totalLimit) {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u041b\u0438\u043c\u0438\u0442 \u042f\u043a\u043e\u0440\u0435\u0439 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 (" + owned + "/" + totalLimit + "). \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u0442\u0430\u0440\u044b\u0439.")), true);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    if (!player.m_7500_()) {
                        player.m_150109_().m_36054_(stack);
                    }
                    return;
                }
                player.getCapability(VorialCapability.INSTANCE).ifPresent(vorial -> {
                    if (vorial.getVorial() < 100 && !player.m_7500_()) {
                        player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u041d\u0443\u0436\u043d\u043e 100 \u0412\u043e\u0440\u0438\u0430\u043b\u044f \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438."), true);
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        if (!player.m_7500_()) {
                            player.m_150109_().m_36054_(new ItemStack((ItemLike)this));
                        }
                        return;
                    }
                    if (!player.m_7500_()) {
                        vorial.removeVorial(100);
                    }
                    skill.changeOwnedAnchorsCount(1);
                    AnchorManager.addAnchor(level, pos);
                    BlockEntity be = level.m_7702_(pos);
                    if (be instanceof SpatialAnchorBlockEntity) {
                        SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)be;
                        anchor.setOwner(player.m_20148_(), player.m_7755_().getString());
                        skill.discoverAnchor(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
                    }
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7a\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u042f\u043a\u043e\u0440\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d!"), true);
                    VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(vorial.getVorial(), vorial.isSuppressed()));
                    this.syncAnchors(player, (ITertserSkill)skill);
                });
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            ServerPlayer player;
            SpatialAnchorBlockEntity anchor;
            UUID ownerId;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof SpatialAnchorBlockEntity && (ownerId = (anchor = (SpatialAnchorBlockEntity)be).getOwnerUUID()) != null && (player = level.m_7654_().m_6846_().m_11259_(ownerId)) != null) {
                player.getCapability(SKILL_CAP).ifPresent(skill -> {
                    skill.changeOwnedAnchorsCount(-1);
                    if (skill instanceof TertserSkill) {
                        TertserSkill impl = (TertserSkill)skill;
                        impl.forgetAnchor(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
                    }
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7e\u0412\u0430\u0448 \u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u042f\u043a\u043e\u0440\u044c \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d."), true);
                    this.syncAnchors(player, (ITertserSkill)skill);
                });
            }
            AnchorManager.removeAnchor(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof SpatialAnchorBlockEntity) {
                SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)be;
                if (anchor.isOwner(player)) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)anchor, (BlockPos)pos);
                    return InteractionResult.SUCCESS;
                }
                if (!anchor.isActive()) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a78\u042d\u0442\u043e\u0442 \u042f\u043a\u043e\u0440\u044c \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435\u043c."), true);
                    return InteractionResult.FAIL;
                }
                if (anchor.isBanned(player.m_20148_())) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435\u043c."), true);
                    return InteractionResult.FAIL;
                }
                player.getCapability(SKILL_CAP).ifPresent(skill -> {
                    GlobalPos gp = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos);
                    if (skill.isAnchorKnown(gp)) {
                        player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\u0412\u044b \u0443\u0436\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u043d\u0430 \u044d\u0442\u043e\u0442 \u042f\u043a\u043e\u0440\u044c."), true);
                    } else {
                        player.getCapability(VorialCapability.INSTANCE).ifPresent(vorial -> {
                            if (vorial.getVorial() >= 50) {
                                vorial.removeVorial(50);
                                skill.discoverAnchor(gp);
                                anchor.registerUser(player);
                                player.m_5661_((Component)Component.m_237113_((String)"\u00a7a\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u042f\u043a\u043e\u0440\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b!"), true);
                                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new VorialSyncPacket(vorial.getVorial(), vorial.isSuppressed()));
                                this.syncAnchors((ServerPlayer)player, (ITertserSkill)skill);
                            } else {
                                player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u041d\u0443\u0436\u043d\u043e 50 \u0412\u043e\u0440\u0438\u0430\u043b\u044f \u0434\u043b\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438."), true);
                            }
                        });
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void syncAnchors(ServerPlayer player, ITertserSkill skill) {
        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TertserSkillSyncPacket(skill.getCurrentLevel(), skill.getJumpsCount(), skill.getTotalJumpsCount(), skill.getAnomaliesCount(), skill.getOwnedAnchorsCount(), skill.getKnownAnchors()));
    }
}

