/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.block.entity;

import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.entity.ModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class StabilizerBlockEntity
extends BlockEntity {
    private int age = 0;
    public static final int MAX_AGE = 300;
    private int targetRiftId = -1;

    public StabilizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.STABILIZER_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StabilizerBlockEntity entity) {
        entity.tick(level, pos);
    }

    private void tick(Level level, BlockPos pos) {
        Entity target;
        if (this.targetRiftId == -1) {
            this.findNearestRift(level, pos);
            if (this.targetRiftId == -1) {
                return;
            }
        }
        if ((target = level.m_6815_(this.targetRiftId)) == null || !target.m_6084_() || !(target instanceof ModEntities.RiftEntity)) {
            this.targetRiftId = -1;
            this.age = 0;
            return;
        }
        ++this.age;
        if (!level.f_46443_ && this.age >= 300) {
            this.finishStabilization(level, pos, target);
        }
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return 300;
    }

    public int getTargetRiftId() {
        return this.targetRiftId;
    }

    private void findNearestRift(Level level, BlockPos pos) {
        AABB searchArea = new AABB(pos).m_82400_(8.0);
        List rifts = level.m_45976_(ModEntities.RiftEntity.class, searchArea);
        ModEntities.RiftEntity nearest = null;
        double minDist = Double.MAX_VALUE;
        for (ModEntities.RiftEntity rift : rifts) {
            double dist = rift.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = rift;
        }
        if (nearest != null) {
            this.targetRiftId = nearest.m_19879_();
            level.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void finishStabilization(Level level, BlockPos pos, Entity riftEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (riftEntity instanceof ModEntities.RiftEntity) {
                ModEntities.RiftEntity rift = (ModEntities.RiftEntity)riftEntity;
                boolean totallyClosed = rift.addStabilization();
                if (totallyClosed) {
                    serverLevel.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2.0f, Level.ExplosionInteraction.NONE);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123767_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 100, 0.5, 0.5, 0.5, 0.5);
                } else {
                    serverLevel.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 50, 0.2, 0.2, 0.2, 0.1);
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("age", this.age);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.age = tag.m_128451_("age");
    }
}

