/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.chat;

import com.example.junctionmod.chat.ChatDataObjects;
import com.example.junctionmod.chat.ChatEvents;
import com.example.junctionmod.chat.ChatFileManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod")
public class ChatCommands {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"mutechat").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            b.suggest("local");
            b.suggest("dim");
            b.suggest("global");
            return b.buildFuture();
        }).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(player.m_20148_());
            boolean newState = false;
            switch (type) {
                case "local": {
                    newState = data.listenLocal = !data.listenLocal;
                    break;
                }
                case "dim": {
                    newState = data.listenDimension = !data.listenDimension;
                    break;
                }
                case "global": {
                    newState = data.listenGlobal = !data.listenGlobal;
                    break;
                }
                default: {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u0422\u0438\u043f\u044b: local, dim, global"));
                    return 0;
                }
            }
            ChatFileManager.savePlayerData(player.m_20148_());
            boolean finalState = newState;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0427\u0430\u0442 " + type + " \u0442\u0435\u043f\u0435\u0440\u044c: " + (finalState ? "\u0412\u041a\u041b" : "\u0412\u042b\u041a\u041b"))), true);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_prefix").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"display", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String display = StringArgumentType.getString((CommandContext)ctx, (String)"display");
            String color = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            display = display.replace("&", "\u00a7");
            ChatFileManager.addPrefix(id, new ChatDataObjects.Prefix(id, display, color));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 " + id + " \u0441\u043e\u0437\u0434\u0430\u043d.")), true);
            return 1;
        })))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"prefix_id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            String pid = StringArgumentType.getString((CommandContext)ctx, (String)"prefix_id");
            if (ChatFileManager.getPrefix(pid) == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                return 0;
            }
            ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(target.m_20148_());
            data.activePrefixId = pid;
            data.unlockedPrefixes.put(pid, 0L);
            ChatFileManager.savePlayerData(target.m_20148_());
            target.refreshTabListName();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0418\u0433\u0440\u043e\u043a\u0443 " + target.m_7755_().getString() + " \u0432\u044b\u0434\u0430\u043d \u043f\u0440\u0435\u0444\u0438\u043a\u0441 " + pid)), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            ChatFileManager.reload();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0447\u0430\u0442\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430."), true);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_chatradius").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int r;
            ChatEvents.LOCAL_RADIUS = r = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0420\u0430\u0434\u0438\u0443\u0441 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0447\u0430\u0442\u0430: " + r)), true);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_mute").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            int mins = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minutes");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(target.m_20148_());
            long expiry = System.currentTimeMillis() + (long)(mins * 60) * 1000L;
            data.activeMutes.put(type, new ChatDataObjects.MuteInfo(expiry, reason, ((CommandSourceStack)ctx.getSource()).m_81368_()));
            String record = System.currentTimeMillis() + ": Muted " + type + " by " + ((CommandSourceStack)ctx.getSource()).m_81368_() + " for " + mins + "m. Reason: " + reason;
            data.muteHistory.add(record);
            ChatFileManager.savePlayerData(target.m_20148_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0418\u0433\u0440\u043e\u043a " + target.m_7755_().getString() + " \u0437\u0430\u0433\u043b\u0443\u0448\u0435\u043d (" + type + ") \u043d\u0430 " + mins + " \u043c\u0438\u043d.")), true);
            target.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u0412\u044b \u0437\u0430\u0433\u043b\u0443\u0448\u0435\u043d\u044b (" + type + ") \u0430\u0434\u043c\u0438\u043d\u043e\u043c " + ((CommandSourceStack)ctx.getSource()).m_81368_() + ". \u041f\u0440\u0438\u0447\u0438\u043d\u0430: " + reason)));
            return 1;
        }))))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_unmute").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(target.m_20148_());
            if (data.activeMutes.containsKey(type)) {
                data.activeMutes.remove(type);
                ChatFileManager.savePlayerData(target.m_20148_());
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u041c\u0443\u0442 \u0441\u043d\u044f\u0442."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u0437\u0430\u0433\u043b\u0443\u0448\u0435\u043d \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0442\u0438\u043f\u0443."));
            }
            return 1;
        }))));
    }
}

