/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.chat;

import com.example.junctionmod.chat.ChatDataObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class ChatFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path ROOT_DIR = FMLPaths.CONFIGDIR.get().resolve("customchat");
    private static final Path PLAYERS_DIR = ROOT_DIR.resolve("players");
    private static final Path PREFIXES_FILE = ROOT_DIR.resolve("prefixes.json");
    private static final Map<String, ChatDataObjects.Prefix> PREFIXES = new HashMap<String, ChatDataObjects.Prefix>();
    private static final Map<UUID, ChatDataObjects.PlayerData> PLAYERS = new HashMap<UUID, ChatDataObjects.PlayerData>();

    public static void init() {
        block12: {
            try {
                if (!Files.exists(ROOT_DIR, new LinkOption[0])) {
                    Files.createDirectories(ROOT_DIR, new FileAttribute[0]);
                }
                if (!Files.exists(PLAYERS_DIR, new LinkOption[0])) {
                    Files.createDirectories(PLAYERS_DIR, new FileAttribute[0]);
                }
                if (Files.exists(PREFIXES_FILE, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(PREFIXES_FILE);){
                        Map loaded = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, ChatDataObjects.Prefix>>(){}.getType());
                        if (loaded != null) {
                            PREFIXES.putAll(loaded);
                        }
                        break block12;
                    }
                }
                PREFIXES.put("default", new ChatDataObjects.Prefix("default", "\u00a77[\u0418\u0433\u0440\u043e\u043a]", "WHITE"));
                PREFIXES.put("admin", new ChatDataObjects.Prefix("admin", "\u00a7c[Admin]", "RED"));
                ChatFileManager.savePrefixes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void savePrefixes() {
        try (BufferedWriter writer = Files.newBufferedWriter(PREFIXES_FILE, new OpenOption[0]);){
            GSON.toJson(PREFIXES, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ChatDataObjects.PlayerData getPlayerData(UUID uuid) {
        if (PLAYERS.containsKey(uuid)) {
            return PLAYERS.get(uuid);
        }
        Path pFile = PLAYERS_DIR.resolve(uuid.toString() + ".json");
        if (Files.exists(pFile, new LinkOption[0])) {
            ChatDataObjects.PlayerData playerData;
            block10: {
                BufferedReader reader = Files.newBufferedReader(pFile);
                try {
                    ChatDataObjects.PlayerData data = (ChatDataObjects.PlayerData)GSON.fromJson((Reader)reader, ChatDataObjects.PlayerData.class);
                    PLAYERS.put(uuid, data);
                    playerData = data;
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ((Reader)reader).close();
            }
            return playerData;
        }
        ChatDataObjects.PlayerData newData = new ChatDataObjects.PlayerData();
        PLAYERS.put(uuid, newData);
        return newData;
    }

    public static void savePlayerData(UUID uuid) {
        ChatDataObjects.PlayerData data = PLAYERS.get(uuid);
        if (data == null) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(PLAYERS_DIR.resolve(uuid.toString() + ".json"), new OpenOption[0]);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ChatDataObjects.Prefix getPrefix(String id) {
        return PREFIXES.get(id);
    }

    public static void addPrefix(String id, ChatDataObjects.Prefix prefix) {
        PREFIXES.put(id, prefix);
        ChatFileManager.savePrefixes();
    }

    public static void reload() {
        PREFIXES.clear();
        PLAYERS.clear();
        ChatFileManager.init();
    }
}

