/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.client.renderer;

import com.example.junctionmod.capability.chunk.ChunkStability;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod", value={Dist.CLIENT})
public class ChunkDebugRenderer {
    public static boolean ENABLED = false;

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (!ENABLED || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Vec3 cameraPos = event.getCamera().m_90583_();
        int pX = mc.f_91074_.m_146902_().f_45578_;
        int pZ = mc.f_91074_.m_146902_().f_45579_;
        for (int x = pX - 2; x <= pX + 2; ++x) {
            int z = pZ - 2;
            while (z <= pZ + 2) {
                LevelChunk chunk = mc.f_91073_.m_6325_(x, z);
                int currentX = x;
                int currentZ = z++;
                chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> {
                    float stab = cap.getStability();
                    double worldX = (currentX << 4) + 8;
                    double worldZ = (currentZ << 4) + 8;
                    double worldY = mc.f_91074_.m_20186_() + 5.0;
                    ChunkDebugRenderer.renderText(poseStack, (MultiBufferSource)buffer, cameraPos, worldX, worldY, worldZ, String.format("%.1f%%", Float.valueOf(stab)), ChunkDebugRenderer.getColor(stab));
                });
            }
        }
    }

    private static void renderText(PoseStack ms, MultiBufferSource buffer, Vec3 cam, double x, double y, double z, String text, int color) {
        ms.m_85836_();
        ms.m_85837_(x - cam.f_82479_, y - cam.f_82480_, z - cam.f_82481_);
        ms.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        ms.m_85841_(-0.05f, -0.05f, 0.05f);
        Minecraft.m_91087_().f_91062_.m_271703_(text, (float)(-Minecraft.m_91087_().f_91062_.m_92895_(text)) / 2.0f, 0.0f, color, true, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ms.m_85849_();
    }

    private static int getColor(float s) {
        if (s > 80.0f) {
            return 65280;
        }
        if (s > 50.0f) {
            return 0xFFFF00;
        }
        if (s > 20.0f) {
            return 16753920;
        }
        return 0xFF0000;
    }
}

