/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.client.renderer;

import com.example.junctionmod.entity.ModEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RiftRenderer
extends EntityRenderer<ModEntities.RiftEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("junctionmod", "textures/entity/rift.png");
    private static final ResourceLocation CROSS_TEXTURE = new ResourceLocation("minecraft", "textures/particle/glitter_7.png");

    public RiftRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(ModEntities.RiftEntity entity) {
        return TEXTURE;
    }

    public void render(ModEntities.RiftEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.getRiftState() == 1) {
            this.renderStitchingUI(entity, partialTicks, poseStack, buffer);
        }
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderStitchingUI(ModEntities.RiftEntity rift, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        Entity viewEntity;
        CompoundTag pointsTag = rift.getStitchPoints();
        if (pointsTag == null || pointsTag.m_128456_()) {
            return;
        }
        int currentIndex = rift.getStitchIndex();
        UUID playerId = rift.getPlayerID();
        Player player = null;
        if (playerId != null) {
            player = rift.m_9236_().m_46003_(playerId);
        }
        if ((viewEntity = Minecraft.m_91087_().f_91075_) == null || viewEntity.m_20280_((Entity)rift) > 256.0) {
            return;
        }
        VertexConsumer starBuilder = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)CROSS_TEXTURE));
        Vec3 riftCenter = rift.m_20182_().m_82520_(0.0, (double)rift.m_20206_() / 2.0, 0.0);
        double centerYOffset = (double)rift.m_20206_() / 2.0;
        Vec3 prevPos = null;
        for (int i = 0; i < 4; ++i) {
            if (!pointsTag.m_128441_(String.valueOf(i))) continue;
            CompoundTag pTag = pointsTag.m_128469_(String.valueOf(i));
            float px = (float)pTag.m_128459_("x");
            float py = (float)pTag.m_128459_("y");
            float pz = (float)pTag.m_128459_("z");
            Vec3 currentPos = riftCenter.m_82520_((double)px, (double)py, (double)pz);
            int r = 255;
            int g = 255;
            int b = 255;
            float size = 0.5f;
            if (i < currentIndex) {
                r = 0;
                g = 255;
                b = 0;
            } else if (i == currentIndex) {
                r = 255;
                g = 215;
                b = 0;
                float pulse = (float)Math.sin((double)rift.f_19797_ * 0.2) * 0.1f + 1.0f;
                size = 0.6f * pulse;
            } else {
                r = 100;
                g = 100;
                b = 100;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)px, centerYOffset + (double)py, (double)pz);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)rift.f_19797_ * 2.0f));
            this.drawCross(starBuilder, poseStack, size, r, g, b, 255);
            poseStack.m_85849_();
            if (i != currentIndex - 1) continue;
            prevPos = currentPos;
        }
        if (player != null && prevPos != null) {
            double pX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_());
            double pY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + (double)player.m_20192_() - 0.3;
            double pZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_());
            Vec3 look = player.m_20252_(partialTicks).m_82490_(0.5);
            Vec3 handPos = new Vec3(pX, pY, pZ).m_82549_(look);
            this.drawParticleLine(prevPos, handPos, new Vector3f(1.0f, 0.8f, 0.0f), rift);
        }
    }

    private void drawCross(VertexConsumer consumer, PoseStack poseStack, float size, int r, int g, int b, int a) {
        float halfSize = size / 2.0f;
        int light = 0xF000F0;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        this.drawQuad(consumer, poseStack.m_85850_(), halfSize, r, g, b, a, light);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        this.drawQuad(consumer, poseStack.m_85850_(), halfSize, r, g, b, a, light);
        poseStack.m_85849_();
    }

    private void drawQuad(VertexConsumer consumer, PoseStack.Pose pose, float s, int r, int g, int b, int a, int light) {
        Matrix4f m = pose.m_252922_();
        Matrix3f n = pose.m_252943_();
        consumer.m_252986_(m, -s, -s, 0.0f).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(m, s, -s, 0.0f).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(m, s, s, 0.0f).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(m, -s, s, 0.0f).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void drawParticleLine(Vec3 start, Vec3 end, Vector3f color, ModEntities.RiftEntity rift) {
        Vec3 up;
        double dist = start.m_82554_(end);
        int count = Math.min(50, Math.max(3, (int)(dist * 8.0)));
        Vec3 dir = end.m_82546_(start).m_82541_();
        Vec3 right = dir.m_82537_(up = new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (right.m_82556_() < 0.001) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 localUp = right.m_82537_(dir).m_82541_();
        long time = rift.m_9236_().m_46467_();
        for (int i = 0; i <= count; ++i) {
            double t = (double)i / (double)count;
            Vec3 linearPos = start.m_165921_(end, t);
            double waveFactor = Math.sin(t * Math.PI);
            double wavePhase = (double)time * 0.2 + (double)i * 0.1;
            double offsetX = Math.sin(wavePhase) * 0.1 * waveFactor;
            double offsetY = Math.cos(wavePhase * 1.3) * 0.1 * waveFactor;
            double sag = Math.sin(t * Math.PI) * (dist * 0.1);
            Vec3 finalPos = linearPos.m_82549_(right.m_82490_(offsetX)).m_82549_(localUp.m_82490_(offsetY - sag));
            rift.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(color, 0.5f), finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

