/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.event;

import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.vorial.EventSyncPacket;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.PacketDistributor;

public class GlobalEventManager
extends SavedData {
    private static final String DATA_NAME = "junctionmod_global_events";
    private static final boolean DEBUG_TICK_LOG = false;
    private static final long MINUTE_IN_MS = 60000L;
    private static final long HOUR_IN_MS = 3600000L;
    private GlobalEventType currentEvent = GlobalEventType.NONE;
    private long eventEndTime = 0L;
    private long nextEventStartTime = 0L;
    private long eventDurationTotal = 1L;
    private String tideSourceDim = "";
    private String tideDrainDim = "";
    private final ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237113_((String)"\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u043d\u043e\u043c\u0430\u043b\u0438\u044f"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private final Random random = new Random();

    public static GlobalEventManager get(ServerLevel level) {
        return (GlobalEventManager)level.m_7654_().m_129783_().m_8895_().m_164861_(GlobalEventManager::load, GlobalEventManager::create, DATA_NAME);
    }

    public static GlobalEventManager create() {
        GlobalEventManager data = new GlobalEventManager();
        data.scheduleNextEvent();
        return data;
    }

    public static GlobalEventManager load(CompoundTag tag) {
        GlobalEventManager data = new GlobalEventManager();
        int eventId = tag.m_128451_("EventID");
        data.currentEvent = eventId >= 0 && eventId < GlobalEventType.values().length ? GlobalEventType.values()[eventId] : GlobalEventType.NONE;
        data.eventEndTime = tag.m_128454_("EventEndTime");
        data.nextEventStartTime = tag.m_128454_("NextEventStartTime");
        data.eventDurationTotal = tag.m_128454_("EventDurationTotal");
        if (data.eventDurationTotal <= 0L) {
            data.eventDurationTotal = 1L;
        }
        data.tideSourceDim = tag.m_128461_("TideSource");
        data.tideDrainDim = tag.m_128461_("TideDrain");
        if (data.currentEvent != GlobalEventType.NONE) {
            data.bossBar.m_6451_(data.currentEvent.getColor());
            data.bossBar.m_6456_(data.currentEvent.getDisplayName());
            data.bossBar.m_8321_(true);
            data.updateBossBar(System.currentTimeMillis());
        } else {
            data.bossBar.m_8321_(false);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("EventID", this.currentEvent.ordinal());
        tag.m_128356_("EventEndTime", this.eventEndTime);
        tag.m_128356_("NextEventStartTime", this.nextEventStartTime);
        tag.m_128356_("EventDurationTotal", this.eventDurationTotal);
        tag.m_128359_("TideSource", this.tideSourceDim);
        tag.m_128359_("TideDrain", this.tideDrainDim);
        return tag;
    }

    public void tick(ServerLevel level) {
        long now = System.currentTimeMillis();
        if (level.m_46467_() % 20L == 0L && this.currentEvent != GlobalEventType.NONE) {
            for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
                this.bossBar.m_6543_(p);
            }
        }
        if (this.currentEvent != GlobalEventType.NONE) {
            if (now >= this.eventEndTime) {
                this.stopEvent(level);
            } else {
                this.updateBossBar(now);
                if (level.m_46467_() % 18000L == 0L) {
                    String desc = this.getEventDescription(this.currentEvent);
                    this.broadcastMessage(level, "\u00a7e\u26a0 \u0421\u0435\u0439\u0447\u0430\u0441 \u043f\u0440\u043e\u0445\u043e\u0434\u0438\u0442 \u0438\u0432\u0435\u043d\u0442: " + this.currentEvent.getDisplayName().getString());
                    this.broadcastMessage(level, "\u00a77\u2139 \u041e\u0441\u043e\u0431\u0435\u043d\u043d\u043e\u0441\u0442\u0438: " + desc);
                }
            }
        } else if (now >= this.nextEventStartTime) {
            this.startRandomEvent(level);
        }
        if (level.m_46467_() % 1200L == 0L) {
            this.m_77762_();
        }
    }

    private String getEventDescription(GlobalEventType type) {
        switch (type) {
            case GREAT_FROST: {
                return "\u0412 \u0425\u0435\u0439\u043b\u0445\u0435\u0439\u043c\u0435 \u043c\u043e\u0440\u043e\u0437 \u0441\u043c\u0435\u0440\u0442\u0435\u043b\u0435\u043d. \u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430, \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u043d\u0438\u0436\u0435\u043d\u0430.";
            }
            case VORIAL_TIDES: {
                return "\u041f\u043e\u0442\u043e\u043a\u0438 \u043c\u0430\u043d\u044b \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u044b. \u0418\u0441\u0442\u043e\u043a (" + this.getDimensionDisplayName(this.tideSourceDim) + ") \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439, \u0423\u0441\u0442\u044c\u0435 (" + this.getDimensionDisplayName(this.tideDrainDim) + ") \u0438\u0441\u0442\u043e\u0449\u0435\u043d\u043e.";
            }
            case SOLAR_FLARE: {
                return "\u0412 \u0410\u043c\u0435\u043d\u0442\u0438 \u0441\u043e\u043b\u043d\u0446\u0435 \u0432\u044b\u0436\u0438\u0433\u0430\u0435\u0442 \u043c\u0430\u043d\u0443 \u0438\u0437 \u043a\u0440\u043e\u0432\u0438. \u0418\u0437\u0431\u0435\u0433\u0430\u0439\u0442\u0435 \u043f\u0440\u044f\u043c\u044b\u0445 \u043b\u0443\u0447\u0435\u0439 \u0438\u043b\u0438 \u0438\u0449\u0438\u0442\u0435 \u0410\u0442\u0435\u0440\u0446\u0435\u043d\u0438\u0442.";
            }
            case VOID_CALL: {
                return "\u0413\u0440\u0430\u043d\u044c \u043c\u0438\u0440\u043e\u0432 \u0438\u0441\u0442\u043e\u043d\u0447\u0438\u043b\u0430\u0441\u044c. \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f \u043e\u043f\u0430\u0441\u043d\u0430 (\u0448\u0430\u043d\u0441 \u043f\u043e\u043f\u0430\u0441\u0442\u044c \u0432 \u041d\u0443\u043d). \u0412 \u041d\u0443\u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u041e\u0432\u0435\u0440\u0447\u0430\u0440\u0434\u0436.";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0430\u043d\u043e\u043c\u0430\u043b\u0438\u044f. \u0411\u0443\u0434\u044c\u0442\u0435 \u043e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u044b.";
    }

    private void scheduleNextEvent() {
        int minHours = 24;
        int maxHours = 48;
        long delayHours = minHours + this.random.nextInt(maxHours - minHours + 1);
        this.nextEventStartTime = System.currentTimeMillis() + delayHours * 3600000L;
        this.m_77762_();
    }

    public void startEvent(ServerLevel level, GlobalEventType type, int durationMinutes) {
        if (this.currentEvent != GlobalEventType.NONE) {
            this.stopEvent(level);
        }
        this.currentEvent = type;
        this.eventDurationTotal = (long)durationMinutes * 60000L;
        this.eventEndTime = System.currentTimeMillis() + this.eventDurationTotal;
        this.bossBar.m_6456_(type.getDisplayName());
        this.bossBar.m_6451_(type.getColor());
        this.bossBar.m_8321_(true);
        this.bossBar.m_142711_(1.0f);
        for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
            this.bossBar.m_6543_(p);
        }
        if (type == GlobalEventType.VORIAL_TIDES) {
            ArrayList<String> dims = new ArrayList<String>();
            for (ResourceKey key : level.m_7654_().m_129784_()) {
                String dimId = key.m_135782_().toString();
                if (dimId.equals("junctionmod:interstice") || dimId.equals("junctionmod:interstice_decay") || dimId.equals("minecraft:the_end")) continue;
                dims.add(dimId);
            }
            Collections.shuffle(dims);
            if (dims.size() >= 2) {
                this.tideSourceDim = (String)dims.get(0);
                this.tideDrainDim = (String)dims.get(1);
            } else {
                this.tideSourceDim = "minecraft:overworld";
                this.tideDrainDim = dims.size() > 0 ? (String)dims.get(0) : "minecraft:the_nether";
            }
            this.broadcastMessage(level, "\u00a7b\ud83c\udf0a \u041f\u0440\u0438\u043b\u0438\u0432\u044b \u0412\u043e\u0440\u0438\u0430\u043b\u044f! \u0418\u0441\u0442\u043e\u043a: " + this.getDimensionDisplayName(this.tideSourceDim) + ", \u0423\u0441\u0442\u044c\u0435: " + this.getDimensionDisplayName(this.tideDrainDim));
        } else {
            this.broadcastMessage(level, "\u00a75\u26a0 \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041d\u0430\u0447\u0430\u043b\u0430\u0441\u044c \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u0430\u043d\u043e\u043c\u0430\u043b\u0438\u044f: " + type.getDisplayName().getString());
        }
        this.broadcastMessage(level, "\u00a77\u2139 " + this.getEventDescription(type));
        this.updateBossBar(System.currentTimeMillis());
        this.m_77762_();
    }

    public void stopEvent(ServerLevel level) {
        if (this.currentEvent != GlobalEventType.NONE) {
            this.broadcastMessage(level, "\u00a7a\u0410\u043d\u043e\u043c\u0430\u043b\u0438\u044f " + this.currentEvent.getDisplayName().getString() + " \u0443\u0442\u0438\u0445\u043b\u0430.");
        }
        this.currentEvent = GlobalEventType.NONE;
        this.bossBar.m_8321_(false);
        this.bossBar.m_7706_();
        this.tideSourceDim = "";
        this.tideDrainDim = "";
        this.scheduleNextEvent();
        this.m_77762_();
    }

    private void startRandomEvent(ServerLevel level) {
        GlobalEventType[] types = GlobalEventType.values();
        if (types.length > 1) {
            GlobalEventType next = types[1 + this.random.nextInt(types.length - 1)];
            int durationHours = 1 + this.random.nextInt(5);
            this.startEvent(level, next, durationHours * 60);
        }
    }

    private void updateBossBar(long now) {
        long timeLeft = this.eventEndTime - now;
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        float progress = 0.0f;
        if (this.eventDurationTotal > 0L) {
            progress = (float)timeLeft / (float)this.eventDurationTotal;
        }
        this.bossBar.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
        long totalSeconds = timeLeft / 1000L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        String timeStr = String.format(" [%02d:%02d:%02d]", hours, minutes, seconds);
        this.bossBar.m_6456_((Component)this.currentEvent.getDisplayName().m_6881_().m_7220_((Component)Component.m_237113_((String)("\u00a7r\u00a77" + timeStr))));
    }

    private void broadcastMessage(ServerLevel level, String msg) {
        level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)msg), false);
    }

    private void broadcastUpdate(ServerLevel level) {
        VorialNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new EventSyncPacket(this.currentEvent));
    }

    public GlobalEventType getCurrentEvent() {
        return this.currentEvent;
    }

    public boolean isEventActive(GlobalEventType type) {
        return this.currentEvent == type;
    }

    public float getVorialRegenMultiplier(String dimensionId) {
        if (this.currentEvent != GlobalEventType.VORIAL_TIDES) {
            return 1.0f;
        }
        if (dimensionId.equals(this.tideSourceDim)) {
            return 2.0f;
        }
        if (dimensionId.equals(this.tideDrainDim)) {
            return 0.1f;
        }
        return 0.8f;
    }

    public boolean isSolarFlareActive() {
        return this.currentEvent == GlobalEventType.SOLAR_FLARE;
    }

    public boolean isVoidCallActive() {
        return this.currentEvent == GlobalEventType.VOID_CALL;
    }

    public void addPlayer(ServerPlayer player) {
        if (this.currentEvent != GlobalEventType.NONE) {
            this.bossBar.m_6543_(player);
        }
    }

    public void removePlayer(ServerPlayer player) {
        this.bossBar.m_6539_(player);
    }

    private String getDimensionDisplayName(String dimId) {
        return switch (dimId) {
            case "minecraft:overworld" -> "\u0410\u0440\u0445\u0435\u043e\u043d";
            case "minecraft:the_nether" -> "\u041d\u0435\u0437\u0435\u0440";
            case "minecraft:the_end" -> "\u041a\u0440\u0430\u0439";
            case "junctionmod:helheim", "junctionworlds:helheim" -> "\u0425\u0435\u0439\u043b\u0445\u0435\u0439\u043c";
            case "junctionmod:amenti", "junctionworlds:amenti" -> "\u0410\u043c\u0435\u043d\u0442\u0438";
            case "aether:the_aether" -> "\u042d\u043b\u0438\u0437\u0438\u0443\u043c";
            case "macabre:the_pit" -> "\u0427\u0440\u0435\u0432\u043e";
            case "blue_skies:everbright" -> "\u042d\u0432\u0435\u0440\u0431\u0440\u0430\u0439\u0442";
            case "blue_skies:everdawn" -> "\u042d\u0432\u0435\u0440\u0434\u043e\u0443\u0440";
            case "valoria:the_valoria" -> "\u0412\u0430\u043b\u043e\u0440\u0438\u044f";
            case "the_afterdark:afterdark" -> "\u041d\u043e\u043a\u0442\u044e\u0440\u043d";
            case "theabyss:the_abyss" -> "\u041d\u0443\u043d";
            default -> dimId;
        };
    }
}

