/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.gui_vorial;

import com.example.junctionmod.entity.ModEntities;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class StitchRequestPacket {
    private final int pointIndex;

    public StitchRequestPacket(int pointIndex) {
        this.pointIndex = pointIndex;
    }

    public static void encode(StitchRequestPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pointIndex);
    }

    public static StitchRequestPacket decode(FriendlyByteBuf buf) {
        return new StitchRequestPacket(buf.readInt());
    }

    public static void handle(StitchRequestPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            player.m_9236_().m_45976_(ModEntities.RiftEntity.class, player.m_20191_().m_82400_(15.0)).stream().filter(r -> r.getTier() == 3).filter(r -> r.getRiftState() == 1).filter(r -> {
                UUID pid = r.getPlayerID();
                return pid != null && pid.equals(player.m_20148_());
            }).findFirst().ifPresent(rift -> {
                CompoundTag points = rift.getStitchPoints();
                if (points != null && points.m_128441_(String.valueOf(msg.pointIndex))) {
                    CompoundTag pTag = points.m_128469_(String.valueOf(msg.pointIndex));
                    Vec3 riftCenter = rift.m_20182_().m_82520_(0.0, (double)rift.m_20206_() / 2.0, 0.0);
                    Vec3 starPos = riftCenter.m_82520_(pTag.m_128459_("x"), pTag.m_128459_("y"), pTag.m_128459_("z"));
                    Vec3 eyePos = player.m_20299_(1.0f);
                    Vec3 toStar = starPos.m_82546_(eyePos).m_82541_();
                    Vec3 look = player.m_20252_(1.0f).m_82541_();
                    double dot = look.m_82526_(toStar);
                    if (dot > 0.9) {
                        rift.progressStitch(player, msg.pointIndex);
                    }
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

