/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.gui_vorial;

import com.example.junctionmod.Atercenite.AterceniteManager;
import com.example.junctionmod.anchor.SpatialAnchorBlockEntity;
import com.example.junctionmod.capability.chunk.ChunkStability;
import com.example.junctionmod.capability.chunk.ChunkStabilityHandler;
import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.entity.ModEntities;
import com.example.junctionmod.event.GlobalEventManager;
import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.partikls.TeleportEffectPacket;
import com.example.junctionmod.tertserskill.ITertserSkill;
import com.example.junctionmod.tertserskill.MadnessManager;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.tertserskill.TertserSkillSyncPacket;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import com.example.junctionmod.world.IntersticeHandler;
import com.example.junctionmod.world.ModDimensions;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class TeleportRequestPacket {
    private static final Capability<ITertserSkill> SKILL_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITertserSkill>(){});
    private final String dimensionId;
    private final BlockPos targetAnchor;
    public static final List<ResourceKey<Level>> ALL_WORLDS = List.of(Level.f_46428_, Level.f_46429_, ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("junctionworlds:helheim")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("junctionworlds:amenty")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("aether:the_aether")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("macabre:the_pit")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("blue_skies:everbright")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("blue_skies:everdawn")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("valoria:the_valoria")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("the_afterdark:afterdark")), ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theabyss:the_abyss")));

    public TeleportRequestPacket(String dimensionId) {
        this(dimensionId, null);
    }

    public TeleportRequestPacket(String dimensionId, BlockPos targetAnchor) {
        this.dimensionId = dimensionId;
        this.targetAnchor = targetAnchor;
    }

    public static TeleportRequestPacket decode(FriendlyByteBuf buf) {
        String dim = buf.m_130277_();
        boolean hasAnchor = buf.readBoolean();
        BlockPos pos = hasAnchor ? buf.m_130135_() : null;
        return new TeleportRequestPacket(dim, pos);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dimensionId);
        buf.writeBoolean(this.targetAnchor != null);
        if (this.targetAnchor != null) {
            buf.m_130064_(this.targetAnchor);
        }
    }

    public static void handle(TeleportRequestPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerLevel targetLevel;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            GlobalEventManager events = GlobalEventManager.get(level);
            boolean hasCascade = player.m_21023_((MobEffect)ModMobEffects.VORIAL_CASCADE.get());
            boolean isAnchorJump = msg.targetAnchor != null;
            ResourceLocation currentDimLoc = level.m_46472_().m_135782_();
            ResourceLocation targetDimLoc = ResourceLocation.m_135820_((String)msg.dimensionId);
            if (targetDimLoc == null) {
                return;
            }
            if (AterceniteManager.isPlayerInField(player)) {
                TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a0 \u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u041a\u0410 \u0410\u0422\u0415\u0420\u0426\u0415\u041d\u0418\u0422\u041e\u041c", -43691);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                return;
            }
            if (player.m_21023_((MobEffect)ModMobEffects.FRACTURED_SPARK.get()) && isAnchorJump) {
                TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a1 \u0418\u0421\u041a\u0420\u0410 \u0420\u0410\u0421\u041a\u041e\u041b\u041e\u0422\u0410", -43691);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0412\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0441\u043b\u0430\u0431\u044b, \u0447\u0442\u043e\u0431\u044b \u0444\u043e\u043a\u0443\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u042f\u043a\u043e\u0440\u044f\u0445."), true);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                return;
            }
            if (events.isEventActive(GlobalEventType.GREAT_FROST) && targetDimLoc.m_135815_().contains("helheim") && !hasCascade) {
                TeleportRequestPacket.sendTitle(player, "\u00a7b\u2744 \u041c\u0418\u0420 \u0417\u0410\u041c\u0415\u0420\u0417 (\u0412\u0425\u041e\u0414 \u0417\u0410\u041a\u0420\u042b\u0422)", -11141121);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\u0412\u0435\u043b\u0438\u043a\u0438\u0439 \u041c\u043e\u0440\u043e\u0437 \u043d\u0435 \u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u0432\u0430\u0441 \u0432 \u0425\u0435\u0439\u043b\u0445\u0435\u0439\u043c."), true);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                return;
            }
            int cost = 200;
            if (isAnchorJump) {
                cost += 50;
            }
            if (events.isEventActive(GlobalEventType.GREAT_FROST) && currentDimLoc.m_135815_().contains("helheim")) {
                cost = 300;
            }
            if (events.isEventActive(GlobalEventType.VOID_CALL) && currentDimLoc.toString().equals("theabyss:the_abyss")) {
                cost = 300;
            }
            if (isAnchorJump && (targetLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)targetDimLoc))) != null && (targetLevel.m_46749_(msg.targetAnchor) || targetLevel.m_7726_().m_5563_(msg.targetAnchor.m_123341_() >> 4, msg.targetAnchor.m_123343_() >> 4))) {
                BlockEntity be = targetLevel.m_7702_(msg.targetAnchor);
                if (be instanceof SpatialAnchorBlockEntity) {
                    SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)be;
                    if (!anchor.isActive()) {
                        TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a0 \u042f\u041a\u041e\u0420\u042c \u041e\u0422\u041a\u041b\u042e\u0427\u0415\u041d", -43691);
                        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                        return;
                    }
                    if (!anchor.isOwner((Player)player) && anchor.isBanned(player.m_20148_())) {
                        TeleportRequestPacket.sendTitle(player, "\u00a7c\u26d4 \u0414\u041e\u0421\u0422\u0423\u041f \u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d", -43776);
                        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                        return;
                    }
                } else {
                    TeleportRequestPacket.sendTitle(player, "\u00a7c\u274c \u0421\u0418\u0413\u041d\u0410\u041b \u041f\u041e\u0422\u0415\u0420\u042f\u041d", -65536);
                    return;
                }
            }
            int finalCost = cost;
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                if (!hasCascade && cap.getVorial() < finalCost) {
                    TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a1 \u041d\u0423\u0416\u041d\u041e " + finalCost + " VORIAL", -43691);
                    return;
                }
                player.getCapability(SKILL_CAP).ifPresent(iSkill -> {
                    double anomalyRoll;
                    ServerLevel noonLevel;
                    TertserSkill skill = (TertserSkill)iSkill;
                    Random rand = new Random();
                    if (skill.incrementJumps()) {
                        TeleportRequestPacket.sendTitle(player, "\u00a76\u2726 \u0413\u041e\u0422\u041e\u0412\u041d\u041e\u0421\u0422\u042c \u041a \u0412\u041e\u0417\u0412\u042b\u0428\u0415\u041d\u0418\u042e \u2726", -22016);
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    int currentLvl = skill.getCurrentLevel();
                    TeleportRequestPacket.impactChunkStability(level, player.m_20183_(), -1.0f);
                    if (events.isEventActive(GlobalEventType.VOID_CALL) && !hasCascade && rand.nextDouble() < 0.25 && (noonLevel = server.m_129880_(ModDimensions.NOON)) != null) {
                        TeleportRequestPacket.payCost(player, cap, finalCost, hasCascade);
                        TeleportRequestPacket.sendTitle(player, "\u00a75\ud83d\udc41 \u041f\u0423\u0421\u0422\u041e\u0422\u0410 \u0417\u041e\u0412\u0415\u0422...", -5635926);
                        TeleportRequestPacket.sendEffectPacket(player, true);
                        player.m_20049_("SKILL_TRAVEL");
                        BlockPos safePos = TeleportRequestPacket.findSafeTeleportSpot(noonLevel, player);
                        player.m_8999_(noonLevel, (double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                        player.m_20137_("SKILL_TRAVEL");
                        TeleportRequestPacket.sendEffectPacket(player, false);
                        TeleportRequestPacket.impactChunkStability(noonLevel, safePos, -1.0f);
                        TeleportRequestPacket.syncSkill(player, skill);
                        return;
                    }
                    if (currentLvl >= 5 && !level.m_46472_().equals(IntersticeHandler.INTERSTICE_KEY)) {
                        double riftChance = (double)(currentLvl - 4) * 0.035;
                        if (riftChance > 0.25) {
                            riftChance = 0.25;
                        }
                        if (rand.nextDouble() < riftChance) {
                            TeleportRequestPacket.payCost(player, cap, finalCost, hasCascade);
                            double x = player.m_20185_() + player.m_20154_().f_82479_ * 2.0;
                            double y = player.m_20186_() + 1.0;
                            double z = player.m_20189_() + player.m_20154_().f_82481_ * 2.0;
                            ModEntities.RiftEntity rift = new ModEntities.RiftEntity((Level)level, x, y, z, msg.dimensionId, currentLvl, 2);
                            level.m_7967_((Entity)rift);
                            level.m_6263_(null, x, y, z, SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 0.5f);
                            TeleportRequestPacket.sendTitle(player, "\u00a75\u26a0 \u0420\u0410\u0417\u041b\u041e\u041c \u041e\u0422\u041a\u0420\u042b\u0422", -5635926);
                            TeleportRequestPacket.syncSkill(player, skill);
                            return;
                        }
                    }
                    double baseAnomalyChance = skill.getAnomalyChance();
                    if (hasCascade) {
                        baseAnomalyChance = 0.0;
                    }
                    if (player.m_21023_((MobEffect)ModMobEffects.EXILE_MARK.get())) {
                        baseAnomalyChance += 0.25;
                    }
                    if ((anomalyRoll = rand.nextDouble()) < baseAnomalyChance) {
                        TeleportRequestPacket.payCost(player, cap, finalCost, hasCascade);
                        skill.incrementAnomalies();
                        TeleportRequestPacket.impactChunkStability(level, player.m_20183_(), -2.0f);
                        if (skill.recordAnomalyEvent()) {
                            player.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.EXILE_MARK.get(), 18000, 0));
                            player.m_5661_((Component)Component.m_237113_((String)"\u00a74\u0412\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0447\u0430\u0441\u0442\u043e \u0442\u0440\u0435\u0432\u043e\u0436\u0438\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e. \u041a\u043b\u0435\u0439\u043c\u043e \u0418\u0437\u0433\u043d\u0430\u043d\u043d\u0438\u043a\u0430 \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u043e."), false);
                        }
                        int sub = rand.nextInt(100) + 1;
                        int fatalThreshold = player.m_21023_((MobEffect)ModMobEffects.EXILE_MARK.get()) ? 90 : 99;
                        player.m_20049_("SKILL_TRAVEL");
                        if (sub <= 65) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
                            TeleportRequestPacket.sendTitle(player, "\u00a7e\u26a0 \u0421\u0420\u042b\u0412 \u041f\u0415\u0420\u0415\u041c\u0415\u0429\u0415\u041d\u0418\u042f", -171);
                            TeleportRequestPacket.sendEffectPacket(player, true);
                        } else if (sub <= fatalThreshold) {
                            List<ResourceKey> possibleWorlds = ALL_WORLDS.stream().filter(key -> !key.equals((Object)level.m_46472_())).toList();
                            ResourceKey randomWorldKey = possibleWorlds.get(rand.nextInt(possibleWorlds.size()));
                            ServerLevel neighborLevel = server.m_129880_(randomWorldKey);
                            if (neighborLevel != null) {
                                BlockPos pos = null;
                                for (int i = 0; i < 15; ++i) {
                                    BlockPos candidate = TeleportRequestPacket.findSafeTeleportSpot(neighborLevel, player);
                                    if (AterceniteManager.isLocationInField((Level)neighborLevel, candidate)) continue;
                                    pos = candidate;
                                    break;
                                }
                                if (pos != null) {
                                    TeleportRequestPacket.sendEffectPacket(player, true);
                                    player.m_8999_(neighborLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                                    TeleportRequestPacket.syncPlayerEffects(player);
                                    String worldName = randomWorldKey.m_135782_().m_135815_().replace("_", " ").toUpperCase();
                                    TeleportRequestPacket.sendTitle(player, "\u00a7e\ud83c\udf00 \u041a\u0420\u0418\u0422\u0418\u0427\u0415\u0421\u041a\u0418\u0419 \u0421\u0411\u041e\u0419: " + worldName, -22016);
                                    TeleportRequestPacket.sendEffectPacket(player, false);
                                } else {
                                    TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a0 \u0421\u0411\u041e\u0419: \u0420\u0415\u0417\u041e\u041d\u0410\u041d\u0421 \u0426\u0415\u041b\u0418", -43691);
                                }
                            }
                        } else {
                            ServerLevel intersticeLevel = server.m_129880_(IntersticeHandler.INTERSTICE_KEY);
                            if (intersticeLevel != null) {
                                TeleportRequestPacket.sendEffectPacket(player, true);
                                player.m_8999_(intersticeLevel, player.m_20185_(), 300.0, player.m_20189_(), player.m_146908_(), player.m_146909_());
                                TeleportRequestPacket.syncPlayerEffects(player);
                                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 60, 20));
                                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"\u00a74\u00a7l\u041c\u0415\u0416\u041c\u0418\u0420\u042c\u0415")));
                                TeleportRequestPacket.sendEffectPacket(player, false);
                            } else {
                                player.m_6074_();
                            }
                        }
                        player.m_20137_("SKILL_TRAVEL");
                        TeleportRequestPacket.syncSkill(player, skill);
                        return;
                    }
                    String actualTargetId = MadnessManager.processTeleport(player, msg.dimensionId);
                    ResourceKey targetDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)actualTargetId));
                    ServerLevel targetLevel = server.m_129880_(targetDim);
                    if (targetLevel == null) {
                        TeleportRequestPacket.sendTitle(player, "\u00a7c\u274c \u041c\u0418\u0420 \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d", -65536);
                        return;
                    }
                    BlockPos finalTargetPos = null;
                    boolean foundValidSpot = false;
                    int attempts = msg.targetAnchor != null ? 1 : 15;
                    for (int i = 0; i < attempts; ++i) {
                        BlockPos candidate;
                        if (i == 0 && msg.targetAnchor != null) {
                            candidate = msg.targetAnchor.m_7494_();
                            if (!targetLevel.m_46859_(candidate)) {
                                candidate = TeleportRequestPacket.findSafeTeleportSpot(targetLevel, player);
                                attempts = 15;
                            }
                        } else {
                            candidate = TeleportRequestPacket.findSafeTeleportSpot(targetLevel, player);
                        }
                        targetLevel.m_46865_(candidate);
                        if (AterceniteManager.isLocationInField((Level)targetLevel, candidate)) continue;
                        finalTargetPos = candidate;
                        foundValidSpot = true;
                        break;
                    }
                    if (!foundValidSpot) {
                        TeleportRequestPacket.sendTitle(player, "\u00a7c\u26a0 \u0426\u0415\u041b\u042c \u041f\u041e\u0414\u0410\u0412\u041b\u0415\u041d\u0410", -43691);
                        player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0412\u0441\u0435 \u0442\u043e\u0447\u043a\u0438 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0442\u044b \u0410\u0442\u0435\u0440\u0446\u0435\u043d\u0438\u0442\u043e\u043c."), true);
                        return;
                    }
                    TeleportRequestPacket.sendEffectPacket(player, true);
                    player.m_20049_("SKILL_TRAVEL");
                    player.m_8999_(targetLevel, (double)finalTargetPos.m_123341_() + 0.5, (double)finalTargetPos.m_123342_(), (double)finalTargetPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    player.m_20137_("SKILL_TRAVEL");
                    boolean teleportSuccessful = player.m_9236_().m_46472_().equals((Object)targetDim);
                    if (teleportSuccessful) {
                        TeleportRequestPacket.payCost(player, cap, finalCost, hasCascade);
                        TeleportRequestPacket.syncPlayerEffects(player);
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11738_, SoundSource.AMBIENT, 2.0f, 0.5f);
                        if (hasCascade) {
                            targetLevel.m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
                            TeleportRequestPacket.sendTitle(player, "\u00a7c\u00a7l\u0423\u0414\u0410\u0420 \u0420\u0415\u0410\u041b\u042c\u041d\u041e\u0421\u0422\u0418", -65536);
                        }
                        TeleportRequestPacket.impactChunkStability(targetLevel, finalTargetPos, -1.0f);
                        TeleportRequestPacket.sendTitle(player, "\u00a7a\ud83c\udf0c \u041f\u0415\u0420\u0415\u0425\u041e\u0414 \u0423\u0421\u041f\u0415\u0428\u0415\u041d", -11141291);
                    } else {
                        TeleportRequestPacket.sendTitle(player, "\u00a7c\u26d4 \u041f\u0415\u0420\u0415\u0425\u041e\u0414 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d", -65536);
                    }
                    TeleportRequestPacket.sendEffectPacket(player, false);
                    TeleportRequestPacket.syncSkill(player, skill);
                });
            });
        });
        ctx.get().setPacketHandled(true);
    }

    private static void payCost(ServerPlayer player, VorialCapability cap, int cost, boolean hasCascade) {
        if (hasCascade) {
            player.m_6469_(player.m_269291_().m_269425_(), 3.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12001_, SoundSource.PLAYERS, 1.0f, 1.5f);
        } else {
            cap.removeVorial(cost);
            VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
        }
    }

    private static void sendTitle(ServerPlayer player, String text, int color) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)text).m_130938_(s -> s.m_178520_(color))));
    }

    private static void sendEffectPacket(ServerPlayer player, boolean start) {
        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TeleportEffectPacket(player.m_19879_(), start));
    }

    private static void syncSkill(ServerPlayer player, TertserSkill skill) {
        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TertserSkillSyncPacket(skill.getCurrentLevel(), skill.getJumpsCount(), skill.getTotalJumpsCount(), skill.getAnomaliesCount(), skill.getOwnedAnchorsCount(), skill.getKnownAnchors()));
    }

    public static BlockPos findSafeTeleportSpot(ServerLevel level, ServerPlayer player) {
        Random random = new Random();
        BlockPos center = level.m_220360_();
        int radius = 100;
        int searchTopY = level.m_151558_();
        int searchBottomY = level.m_141937_();
        if (level.m_46472_() == Level.f_46429_) {
            searchTopY = 118;
            searchBottomY = 32;
        }
        for (int attempt = 0; attempt < 200; ++attempt) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double dist = random.nextDouble() * (double)radius;
            int x = (int)((double)center.m_123341_() + Math.cos(angle) * dist);
            int z = (int)((double)center.m_123343_() + Math.sin(angle) * dist);
            for (int y = searchTopY; y > searchBottomY; --y) {
                BlockPos below;
                BlockPos current = new BlockPos(x, y, z);
                if (!level.m_6425_(current).m_76178_() || !level.m_6425_(current.m_7494_()).m_76178_() || !level.m_46859_(current) || !level.m_46859_(current.m_7494_()) || level.m_46859_(below = current.m_7495_()) || !level.m_6425_(below).m_76178_() || level.m_8055_(below).m_60713_(Blocks.f_50752_) || level.m_8055_(below).m_60713_(Blocks.f_50450_)) continue;
                return current;
            }
        }
        int fallbackY = level.m_46472_() == Level.f_46429_ ? 70 : 80;
        BlockPos.MutableBlockPos fallback = new BlockPos.MutableBlockPos(center.m_123341_(), fallbackY, center.m_123343_());
        while (fallback.m_123342_() < level.m_151558_() && !level.m_46859_((BlockPos)fallback)) {
            fallback.m_122184_(0, 1, 0);
        }
        if (fallback.m_123342_() >= level.m_151558_()) {
            fallback.m_142448_(fallbackY);
            while (fallback.m_123342_() > level.m_141937_() && !level.m_46859_((BlockPos)fallback)) {
                fallback.m_122184_(0, -1, 0);
            }
        }
        return fallback.m_7949_();
    }

    private static void impactChunkStability(ServerLevel level, BlockPos pos, float amount) {
        LevelChunk chunk = level.m_46745_(pos);
        chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> {
            cap.addStability(amount);
            ChunkStabilityHandler.sendSyncPacket(level, chunk.m_7697_(), cap.getStability());
        });
    }

    private static void syncPlayerEffects(ServerPlayer player) {
        for (MobEffectInstance effect : player.m_21220_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect));
        }
    }
}

