/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.gui_vorial;

import com.example.junctionmod.Atercenite.AterceniteManager;
import com.example.junctionmod.anchor.SpatialAnchorBlockEntity;
import com.example.junctionmod.gui_vorial.TeleportRequestPacket;
import com.example.junctionmod.tertserskill.ITertserSkill;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class VorialWorldSelectScreen
extends Screen {
    private static final float SCROLL_SENSITIVITY = 8.0f;
    private static final float SMOOTH_SPEED = 10.0f;
    private static final long CHAR_REVEAL_SPEED = 30L;
    private static final Capability<ITertserSkill> SKILL_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITertserSkill>(){});
    private static final List<WorldEntry> WORLDS_MASTER = List.of(new WorldEntry("\u0410\u0440\u0445\u0435\u043e\u043d", "minecraft:overworld", 0x55FF55, "\u0417\u0435\u043b\u0451\u043d\u044b\u0435 \u043f\u0440\u043e\u0441\u0442\u043e\u0440\u044b \u043f\u043e\u0434 \u043c\u044f\u0433\u043a\u0438\u043c \u0441\u043e\u043b\u043d\u0446\u0435\u043c."), new WorldEntry("\u041d\u0435\u0437\u0435\u0440", "minecraft:the_nether", 0xFF5555, "\u0411\u0430\u0433\u0440\u043e\u0432\u044b\u0435 \u043d\u0435\u0431\u0435\u0441\u0430 \u0438 \u0440\u0435\u043a\u0438 \u043c\u0430\u0433\u043c\u044b."), new WorldEntry("\u0425\u0435\u0439\u043b\u0445\u0435\u0439\u043c", "junctionworlds:helheim", 10543359, "\u041b\u0435\u0434\u044f\u043d\u044b\u0435 \u043f\u0443\u0441\u0442\u043e\u0448\u0438."), new WorldEntry("\u0410\u043c\u0435\u043d\u0442\u0438", "junctionworlds:amenty", 16753920, "\u041f\u0443\u0441\u0442\u044b\u043d\u044f, \u0432\u044b\u0436\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u043e\u043b\u043d\u0446\u0435\u043c."), new WorldEntry("\u042d\u043b\u0438\u0437\u0438\u0443\u043c", "aether:the_aether", 8900331, "\u041f\u0430\u0440\u044f\u0449\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430."), new WorldEntry("\u0427\u0440\u0435\u0432\u043e", "macabre:the_pit", 0x8B0000, "\u0416\u0438\u0432\u043e\u0439 \u043a\u043e\u0448\u043c\u0430\u0440 \u0438\u0437 \u043f\u043b\u043e\u0442\u0438."), new WorldEntry("\u042d\u0432\u0435\u0440\u0431\u0440\u0430\u0439\u0442", "blue_skies:everbright", 0xFFFF80, "\u041a\u0440\u0438\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043b\u0435\u0441\u0430."), new WorldEntry("\u042d\u0432\u0435\u0440\u0434\u043e\u0443\u0440", "blue_skies:everdawn", 16738740, "\u0411\u0430\u0433\u0440\u043e\u0432\u044b\u0435 \u043a\u0430\u043d\u044c\u043e\u043d\u044b."), new WorldEntry("\u0412\u0430\u043b\u043e\u0440\u0438\u044f", "valoria:the_valoria", 13938487, "\u0420\u0443\u0438\u043d\u044b \u0434\u0440\u0435\u0432\u043d\u0435\u0439 \u0446\u0438\u0432\u0438\u043b\u0438\u0437\u0430\u0446\u0438\u0438."), new WorldEntry("\u041d\u043e\u043a\u0442\u044e\u0440\u043d", "the_afterdark:afterdark", 4915330, "\u0426\u0430\u0440\u0441\u0442\u0432\u043e \u0432\u0435\u0447\u043d\u043e\u0439 \u0442\u0435\u043d\u0438."), new WorldEntry("\u041d\u0443\u043d", "theabyss:the_abyss", 9699539, "\u0411\u0443\u0448\u0443\u044e\u0449\u0438\u0439 \u043e\u043a\u0435\u0430\u043d \u0445\u0430\u043e\u0441\u0430."));
    private final List<WorldEntry> availableWorlds = new ArrayList<WorldEntry>();
    private float currentIndex = 0.0f;
    private float targetIndex = 0.0f;
    private float velocity = 0.0f;
    private int lastSelectedIndex = -1;
    private List<AnchorEntry> currentAnchors = new ArrayList<AnchorEntry>();
    private float anchorIndex = 0.0f;
    private float targetAnchorIndex = 0.0f;
    private float anchorVelocity = 0.0f;
    private boolean isCharging = false;
    private boolean isChargingAnchor = false;
    private long chargeStartTime = 0L;
    private long lastTime = System.currentTimeMillis();
    private String currentDescription = "";
    private int descriptionDisplayLength = 0;
    private long lastDescriptionUpdateTime = 0L;
    private String playerRankCache = "-";
    private int playerLevelCache = 0;
    private List<GlobalPos> knownAnchorsCache = new ArrayList<GlobalPos>();

    public VorialWorldSelectScreen() {
        super((Component)Component.m_237113_((String)"\u0412\u044b\u0431\u043e\u0440 \u043c\u0438\u0440\u0430"));
    }

    protected void m_7856_() {
        this.availableWorlds.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.f_108617_ != null) {
            Set knownLevels = mc.f_91074_.f_108617_.m_105151_();
            for (WorldEntry entry : WORLDS_MASTER) {
                ResourceKey key;
                ResourceLocation id = ResourceLocation.m_135820_((String)entry.dimensionId());
                if (id == null || !knownLevels.contains(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id))) continue;
                this.availableWorlds.add(entry);
            }
        }
        if (this.availableWorlds.isEmpty()) {
            this.availableWorlds.add(WORLDS_MASTER.get(0));
        }
        int startWorldIndex = 0;
        if (mc.f_91073_ != null) {
            ResourceLocation currentDim = mc.f_91073_.m_46472_().m_135782_();
            for (int i = 0; i < this.availableWorlds.size(); ++i) {
                if (!this.availableWorlds.get(i).dimensionId().equals(currentDim.toString())) continue;
                startWorldIndex = i;
                break;
            }
        }
        this.currentIndex = this.targetIndex = (float)startWorldIndex;
        this.velocity = 0.0f;
        this.targetAnchorIndex = 0.0f;
        this.anchorIndex = 0.0f;
        this.anchorVelocity = 0.0f;
        this.lastSelectedIndex = this.wrapIndex(Math.round(this.currentIndex), this.availableWorlds.size());
        this.currentDescription = this.availableWorlds.get(this.lastSelectedIndex).description();
        this.descriptionDisplayLength = 0;
        this.lastDescriptionUpdateTime = System.currentTimeMillis();
        this.fetchPlayerData();
        this.updateCurrentAnchors(this.lastSelectedIndex);
    }

    private void fetchPlayerData() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.getCapability(SKILL_CAP).ifPresent(skill -> {
                this.playerLevelCache = skill.getCurrentLevel();
                this.playerRankCache = this.getRankName(this.playerLevelCache);
                this.knownAnchorsCache = skill.getKnownAnchors();
            });
        }
    }

    private void updateCurrentAnchors(int worldIdx) {
        this.currentAnchors.clear();
        if (worldIdx < 0 || worldIdx >= this.availableWorlds.size()) {
            return;
        }
        String currentDimId = this.availableWorlds.get(worldIdx).dimensionId();
        ResourceLocation dimLoc = ResourceLocation.m_135820_((String)currentDimId);
        if (dimLoc != null && !this.knownAnchorsCache.isEmpty()) {
            Minecraft mc = Minecraft.m_91087_();
            for (GlobalPos gp : this.knownAnchorsCache) {
                BlockEntity be;
                if (!gp.m_122640_().m_135782_().equals((Object)dimLoc)) continue;
                StringBuilder nameBuilder = new StringBuilder("[ " + gp.m_122646_().m_123344_() + " ]");
                if (mc.f_91074_ != null) {
                    mc.f_91074_.getCapability(SKILL_CAP).ifPresent(s -> {
                        TertserSkill ts;
                        String cached;
                        if (s instanceof TertserSkill && (cached = (ts = (TertserSkill)s).getAnchorNames().get(gp)) != null) {
                            nameBuilder.setLength(0);
                            nameBuilder.append(cached);
                        }
                    });
                }
                if (mc.f_91073_ != null && mc.f_91073_.m_46472_().m_135782_().equals((Object)dimLoc) && mc.f_91073_.m_46749_(gp.m_122646_()) && (be = mc.f_91073_.m_7702_(gp.m_122646_())) instanceof SpatialAnchorBlockEntity) {
                    SpatialAnchorBlockEntity anchorBe = (SpatialAnchorBlockEntity)be;
                    nameBuilder.setLength(0);
                    nameBuilder.append(anchorBe.getAnchorName());
                }
                String finalName = nameBuilder.toString();
                boolean isSuppressed = false;
                boolean isOwner = false;
                boolean isLocked = false;
                if (mc.f_91073_ != null && mc.f_91073_.m_46472_().m_135782_().equals((Object)dimLoc)) {
                    SpatialAnchorBlockEntity anchorBe;
                    BlockEntity be2;
                    isSuppressed = AterceniteManager.isLocationInField((Level)mc.f_91073_, gp.m_122646_());
                    if (mc.f_91073_.m_46749_(gp.m_122646_()) && (be2 = mc.f_91073_.m_7702_(gp.m_122646_())) instanceof SpatialAnchorBlockEntity && !(isOwner = (anchorBe = (SpatialAnchorBlockEntity)be2).isOwner((Player)mc.f_91074_))) {
                        isLocked = !anchorBe.isActive() || anchorBe.isBanned(mc.f_91074_.m_20148_());
                    }
                }
                this.currentAnchors.add(new AnchorEntry(finalName, gp.m_122646_(), isOwner, isSuppressed, isLocked));
            }
        }
        this.targetAnchorIndex = 0.0f;
        this.anchorIndex = 0.0f;
        this.anchorVelocity = 0.0f;
    }

    private int wrapIndex(int index, int size) {
        if (size == 0) {
            return 0;
        }
        return (index % size + size) % size;
    }

    private float wrapIndexFloat(float index, int size) {
        if (size == 0) {
            return 0.0f;
        }
        if (index < 0.0f) {
            index += (float)size;
        }
        if (index >= (float)size) {
            index -= (float)size;
        }
        return index;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int centerX = this.f_96543_ / 2;
        if (!this.currentAnchors.isEmpty() && mouseX > (double)(centerX + 50)) {
            this.anchorVelocity = (float)((double)this.anchorVelocity - delta * (double)0.45f);
        } else {
            this.velocity = (float)((double)this.velocity - delta * (double)0.45f);
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.isCharging) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                int cost;
                boolean clickOnAnchor;
                int centerX = this.f_96543_ / 2;
                boolean bl = clickOnAnchor = !this.currentAnchors.isEmpty() && mouseX > (double)(centerX + 50);
                if (clickOnAnchor) {
                    int anchorIdx = this.wrapIndex(Math.round(this.anchorIndex), this.currentAnchors.size());
                    AnchorEntry entry = this.currentAnchors.get(anchorIdx = Math.max(0, Math.min(anchorIdx, this.currentAnchors.size() - 1)));
                    if (entry.isSuppressed()) {
                        this.playErrorSound(mc);
                        mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a78\u042d\u0442\u043e\u0442 \u044f\u043a\u043e\u0440\u044c \u043f\u043e\u0434\u0430\u0432\u043b\u0435\u043d \u0410\u0442\u0435\u0440\u0446\u0435\u043d\u0438\u0442\u043e\u043c."), true);
                        return false;
                    }
                    if (entry.isLocked()) {
                        this.playErrorSound(mc);
                        mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435\u043c."), true);
                        return false;
                    }
                }
                int n = cost = clickOnAnchor ? 250 : 200;
                if (!this.canTeleport((Player)mc.f_91074_, cost)) {
                    this.playErrorSound(mc);
                    mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e Vorial! (" + cost + ")")), true);
                    return false;
                }
                this.isCharging = true;
                this.isChargingAnchor = clickOnAnchor;
                this.chargeStartTime = System.currentTimeMillis();
                mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), SoundEvents.f_11737_, SoundSource.PLAYERS, 0.3f, 1.3f, false);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void playErrorSound(Minecraft mc) {
        if (mc.f_91074_ != null) {
            mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 0.7f, 0.5f, false);
        }
    }

    private boolean canTeleport(Player player, int cost) {
        return player.getCapability(VorialCapability.INSTANCE).map(cap -> cap.getVorial() >= cost).orElse(false);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isCharging) {
            this.isCharging = false;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.PLAYERS, 0.5f, 0.6f, false);
            }
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void completeCharge() {
        this.isCharging = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.4f, false);
            int worldIdx = this.wrapIndex(Math.round(this.currentIndex), this.availableWorlds.size());
            String dimId = this.availableWorlds.get(worldIdx).dimensionId();
            BlockPos anchorPos = null;
            if (this.isChargingAnchor && !this.currentAnchors.isEmpty()) {
                int anchorIdx = this.wrapIndex(Math.round(this.anchorIndex), this.currentAnchors.size());
                anchorIdx = Math.max(0, Math.min(anchorIdx, this.currentAnchors.size() - 1));
                anchorPos = this.currentAnchors.get(anchorIdx).pos();
            }
            VorialNetwork.CHANNEL.sendToServer((Object)new TeleportRequestPacket(dimId, anchorPos));
        }
        mc.m_91152_(null);
    }

    private void drawGradientText(GuiGraphics g, String text, int x, int y, float progress, int targetColor) {
        Minecraft mc = Minecraft.m_91087_();
        int total = text.length();
        float perChar = 1.0f / (float)total;
        int targetR = targetColor >> 16 & 0xFF;
        int targetG = targetColor >> 8 & 0xFF;
        int targetB = targetColor & 0xFF;
        int drawX = x;
        for (int i = 0; i < total; ++i) {
            char c = text.charAt(i);
            float start = perChar * (float)i;
            float end = perChar * (float)(i + 1);
            float t = (progress - start) / (end - start);
            t = Math.max(0.0f, Math.min(1.0f, t));
            int r = (int)(255.0f * (1.0f - t) + (float)targetR * t);
            int gC = (int)(255.0f * (1.0f - t) + (float)targetG * t);
            int b = (int)(255.0f * (1.0f - t) + (float)targetB * t);
            int color = 0xFF000000 | r << 16 | gC << 8 | b;
            g.m_280488_(mc.f_91062_, String.valueOf(c), drawX, y, color);
            drawX += mc.f_91062_.m_92895_(String.valueOf(c));
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        String textToDisplay;
        int descWidth;
        this.m_280273_(g);
        long now = System.currentTimeMillis();
        float delta = (float)(now - this.lastTime) / 1000.0f;
        this.lastTime = now;
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.targetIndex += this.velocity * delta * 8.0f;
        this.velocity *= 0.9f;
        this.targetIndex = this.wrapIndexFloat(this.targetIndex, this.availableWorlds.size());
        float diffW = this.targetIndex - this.currentIndex;
        if (Math.abs(diffW) > (float)this.availableWorlds.size() / 2.0f) {
            this.currentIndex = diffW > 0.0f ? (this.currentIndex += (float)this.availableWorlds.size()) : (this.currentIndex -= (float)this.availableWorlds.size());
        }
        this.currentIndex += (this.targetIndex - this.currentIndex) * Math.min(delta * 10.0f, 1.0f);
        this.currentIndex = this.wrapIndexFloat(this.currentIndex, this.availableWorlds.size());
        int selectedWorld = this.wrapIndex(Math.round(this.currentIndex), this.availableWorlds.size());
        if (this.lastSelectedIndex != selectedWorld) {
            this.updateCurrentAnchors(selectedWorld);
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91073_.m_7785_(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_(), Minecraft.m_91087_().f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12215_.m_203334_(), SoundSource.PLAYERS, 0.4f, 1.8f, false);
            }
            if (!this.availableWorlds.isEmpty()) {
                this.currentDescription = this.availableWorlds.get(selectedWorld).description();
            }
            this.descriptionDisplayLength = 0;
            this.lastDescriptionUpdateTime = now;
        }
        this.lastSelectedIndex = selectedWorld;
        if (!this.currentAnchors.isEmpty()) {
            this.targetAnchorIndex += this.anchorVelocity * delta * 8.0f;
            this.anchorVelocity *= 0.9f;
            float maxIdx = Math.max(0, this.currentAnchors.size() - 1);
            this.targetAnchorIndex = Math.max(0.0f, Math.min(maxIdx, this.targetAnchorIndex));
            this.anchorIndex += (this.targetAnchorIndex - this.anchorIndex) * Math.min(delta * 10.0f, 1.0f);
        }
        this.renderWheel(g, this.availableWorlds, this.currentIndex, cx, cy, !this.isChargingAnchor && this.isCharging, 0xFFFFFF, 1.0f);
        if (!this.currentAnchors.isEmpty()) {
            int anchorX = cx + 130;
            g.m_280315_(cx + 65, cy - 80, cy + 80, 0x44FFFFFF);
            g.m_280137_(this.f_96547_, "\u042f\u041a\u041e\u0420\u042f", anchorX, cy - 90, 0xAAAAAA);
            this.renderAnchorWheel(g, this.anchorIndex, anchorX, cy, this.isChargingAnchor && this.isCharging, 0.65f);
        }
        if (!this.availableWorlds.isEmpty()) {
            WorldEntry currentWorld = this.availableWorlds.get(selectedWorld);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)cx, (float)(cy - 130), 0.0f);
            float p = (float)(Math.sin((double)now / 1800.0 * Math.PI * 2.0) * 0.05 + 0.95);
            g.m_280168_().m_85841_(2.0f * p, 2.0f * p, 2.0f);
            g.m_280137_(this.f_96547_, currentWorld.displayName(), 0, 0, currentWorld.color());
            g.m_280168_().m_85849_();
        }
        int levelColor = this.playerLevelCache >= 5 ? 0xFFAA00 : 0xA0A0FF;
        String powerText = "\u0423\u0440\u043e\u0432\u0435\u043d\u044c: " + this.playerLevelCache + " (" + this.playerRankCache + ")";
        g.m_280137_(this.f_96547_, powerText, cx, cy + 130, levelColor);
        if (this.descriptionDisplayLength < this.currentDescription.length() && now - this.lastDescriptionUpdateTime > 30L) {
            ++this.descriptionDisplayLength;
            this.lastDescriptionUpdateTime = now;
        }
        if ((descWidth = this.f_96547_.m_92895_(textToDisplay = this.currentDescription.substring(0, this.descriptionDisplayLength))) > 0) {
            g.m_280509_(cx - descWidth / 2 - 4, cy + 106, cx + descWidth / 2 + 4, cy + 120, 0x44000000);
        }
        g.m_280137_(this.f_96547_, textToDisplay, cx, cy + 110, 0xDDDDDD);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderWheel(GuiGraphics g, List<?> items, float currentIndex, int x, int y, boolean activeCharge, int baseColor, float baseScale) {
        int size = items.size();
        int centerIndex = Math.round(currentIndex);
        float spacing = 35.0f * baseScale;
        for (int i = 0; i < size; ++i) {
            int displayColor;
            int n;
            Object text;
            int alpha;
            float dist;
            for (dist = (float)i - currentIndex; dist < (float)(-size) / 2.0f; dist += (float)size) {
            }
            while (dist > (float)size / 2.0f) {
                dist -= (float)size;
            }
            if (Math.abs(dist) > 3.0f) continue;
            float yPos = (float)y + dist * spacing;
            float fade = Math.max(0.0f, 1.0f - Math.abs(dist) / 3.0f);
            if ((alpha = (int)((fade *= fade) * 255.0f)) < 5) continue;
            float scale = baseScale * (1.0f + 0.5f * (1.0f - Math.abs(dist) / 3.0f));
            Object item = items.get(i);
            if (item instanceof WorldEntry) {
                WorldEntry w = (WorldEntry)item;
                v0 = w.displayName();
            } else {
                v0 = text = item.toString();
            }
            if (item instanceof WorldEntry) {
                WorldEntry w = (WorldEntry)item;
                n = w.color();
            } else {
                n = baseColor;
            }
            int targetColor = n;
            boolean isSelected = i == this.wrapIndex(centerIndex, size);
            int n2 = displayColor = isSelected ? 0xFFFFFF : 0xAAAAAA;
            if (!isSelected) {
                scale *= 0.8f;
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)x, yPos, 0.0f);
            g.m_280168_().m_85841_(scale, scale, 1.0f);
            int packedColor = alpha << 24 | displayColor & 0xFFFFFF;
            if (isSelected) {
                text = ">> " + (String)text + " <<";
            }
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_((String)text);
            if (isSelected && activeCharge) {
                long now = System.currentTimeMillis();
                float progress = (float)(now - this.chargeStartTime) / ((float)((String)text).length() * 120.0f);
                if (progress >= 1.0f) {
                    this.completeCharge();
                    g.m_280168_().m_85849_();
                    return;
                }
                this.drawGradientText(g, (String)text, -textWidth / 2, -4, progress, targetColor);
            } else {
                g.m_280137_(this.f_96547_, (String)text, 0, -4, packedColor);
            }
            g.m_280168_().m_85849_();
        }
    }

    private void renderAnchorWheel(GuiGraphics g, float currentIndex, int x, int y, boolean activeCharge, float baseScale) {
        int size = this.currentAnchors.size();
        float spacing = 25.0f;
        for (int i = 0; i < size; ++i) {
            boolean isSelected;
            int alpha;
            float dist = (float)i - currentIndex;
            if (Math.abs(dist) > 3.0f) continue;
            float yPos = (float)y + dist * spacing;
            float fade = Math.max(0.0f, 1.0f - Math.abs(dist) / 3.0f);
            if ((alpha = (int)((fade *= fade) * 255.0f)) < 5) continue;
            float scale = baseScale * (1.0f + 0.4f * (1.0f - Math.abs(dist) / 3.0f));
            AnchorEntry entry = this.currentAnchors.get(i);
            String text = entry.name();
            int color = entry.isSuppressed() || entry.isLocked() ? 0x444444 : (entry.isOwner() ? 0x55FF55 : 0x55FFFF);
            boolean bl = isSelected = i == Math.round(currentIndex);
            if (!isSelected) {
                color = 0x888888;
                scale *= 0.9f;
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)x, yPos, 0.0f);
            g.m_280168_().m_85841_(scale, scale, 1.0f);
            int packedColor = alpha << 24 | color;
            g.m_280488_(this.f_96547_, (String)(isSelected ? "\u2693 " + text : text), -this.f_96547_.m_92895_(text) / 2, -4, packedColor);
            if (isSelected && activeCharge) {
                long now = System.currentTimeMillis();
                float progress = (float)(now - this.chargeStartTime) / 1500.0f;
                if (progress >= 1.0f) {
                    this.completeCharge();
                    g.m_280168_().m_85849_();
                    return;
                }
                int barW = 40;
                g.m_280509_(-barW / 2, 6, -barW / 2 + (int)((float)barW * progress), 8, -1);
            }
            g.m_280168_().m_85849_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private String getRankName(int level) {
        return switch (level) {
            case 0 -> "\u041d\u0435\u043e\u0444\u0438\u0442";
            case 1 -> "\u041d\u043e\u0432\u0438\u0446\u0438\u0443\u0441";
            case 2 -> "\u0412\u0438\u0430\u0442\u043e\u0440";
            case 3 -> "\u042d\u043a\u0441\u043f\u043b\u043e\u0440\u0430\u0442\u043e\u0440";
            case 4 -> "\u0421\u043f\u0435\u043a\u0443\u043b\u044f\u0442\u043e\u0440";
            case 5 -> "\u0414\u0443\u043a\u0441";
            case 6 -> "\u041f\u0440\u0435\u0444\u0435\u043a\u0442\u0443\u0441";
            case 7 -> "\u0410\u0431\u0438\u0441\u0441\u043e\u043a\u0440\u0430\u0442\u043e\u0440";
            case 8 -> "\u0421\u0442\u0438\u043b\u043e\u043d\u043e\u043c\u043e\u0441";
            case 9 -> "\u041a\u043e\u043d\u0434\u0438\u0442\u043e\u0440";
            case 10 -> "\u0410\u0443\u043a\u0442\u043e\u0440 \u0412\u0438\u0430\u0440\u0443\u043c";
            default -> "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439";
        };
    }

    private record WorldEntry(String displayName, String dimensionId, int color, String description) {
    }

    private record AnchorEntry(String name, BlockPos pos, boolean isOwner, boolean isSuppressed, boolean isLocked) {
    }
}

